% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_create_or_update_request.R
\name{file_create_or_update_request}
\alias{file_create_or_update_request}
\title{Create object for adding/updating a dataset file.}
\usage{
file_create_or_update_request(file_name, url = NULL, description = NULL,
  labels = NULL)
}
\arguments{
\item{file_name}{File name including the file extension. If a file by that name already
exists in the dataset, the file will be updated/overwritten.}

\item{url}{(optional) Source URL for file.}

\item{description}{(optional) File description.}

\item{labels}{(optional) List of file labels ("raw data", "documentation",
"visualization", "clean data", "script" or "report").}
}
\value{
Object of type \code{file_create_or_update_request}.
}
\description{
Create object for adding/updating a dataset file.
}
\examples{
file_create_or_update_req <- dwapi::file_create_or_update_request(
  file_name = "file.csv",
  url = "https://data.world/file.csv",
  description = "My updated CSV description",
  labels = list("raw data", "clean data"))
}
\seealso{
\code{\link{file_batch_update_request}}, \code{\link{update_dataset}}
}
