% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_NSE_RMSE.R
\name{nse.rmse}
\alias{nse.rmse}
\title{Calculate fit of goodness of DYCD model simulations.}
\usage{
nse.rmse(
  sim,
  obs,
  start.date = "2017-06-06",
  end.date = "2020-02-29",
  min.depth = 0,
  max.depth = 33,
  by.value = 0.5
)
}
\arguments{
\item{sim}{a matrix of bio-geochemical variable values with column of time and row of depth.}

\item{obs}{a data frame of observed value, with three columns: Date, depth, value.}

\item{start.date, end.date}{the beginning and ending simulation dates for the intended DYRESM-CAEDYM model run. The date format must be "\%Y-\%m-\%d".}

\item{min.depth, max.depth}{minimum and maximum depth to be compared between simulations and observations.}

\item{by.value}{the value of increment for depth.}
}
\value{
a vector of objective function values. The first is NSE and the second is RMSE.
}
\description{
Two objective functions can be calculated: 1) Nash-Sutcliffe efficiency coefficient (NSE),
  and 2) Root Mean Square Error (RMSE).
}
