% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Scatter-plot.R
\name{plot_scatter}
\alias{plot_scatter}
\title{Scatter plot of sim and obs var values}
\usage{
plot_scatter(
  sim = temp.interpolated,
  obs = obs.temp,
  sim.start = "2017-06-06",
  sim.end = "2020-02-29",
  plot.start = "2017-06-06",
  plot.end = "2020-02-29",
  min.depth = 0,
  max.depth,
  by.value,
  plot.save = TRUE,
  file_name,
  height = 4,
  width = 7
)
}
\arguments{
\item{sim}{interpolated values of variable.}

\item{obs}{observed values of variable. This data need to have fixed types of colnames and orders.}

\item{sim.start, sim.end}{the beginning and ending simulation dates for the intended DYRESM-CAEDYM model run. The date format must be "\%Y-\%m-\%d".}

\item{plot.start, plot.end}{the beginning and ending dates for the plotting purpose. The date format must be "\%Y-\%m-\%d".}

\item{min.depth, max.depth, by.value}{minimum and maximum depth for the profile plot at the depth increment of by.value.}

\item{plot.save}{if TRUE, the plot is saved with the "height","width", and "ppi" parameters.}

\item{file_name}{the file path to save the generated scatter plot.}

\item{height, width}{the height and width of the scatter figure.}
}
\value{
a scatter plot of sim vs. obs
}
\description{
Scatter plot of sim and obs var values
}
\examples{
 var.values<-ext.output(dycd.output=system.file("extdata", "dysim.nc", package = "dycdtools"),
                       var.extract=c("TEMP"))

 for(i in 1:length(var.values)){
   expres<-paste0(names(var.values)[i],"<-data.frame(var.values[[",i,"]])")
   eval(parse(text=expres))
  }

# interpolate temperature for depths from 0 to 13 m at increment of 0.5 m
  temp.interpolated<-interpol(layerHeights = dyresmLAYER_HTS_Var,
                             var = dyresmTEMPTURE_Var,
                             min.dept = 0,max.dept = 13,by.value = 0.5)

 data(obs_temp)

# scatter plot of sim and obs temperature
 plot_scatter(sim=temp.interpolated,
              obs=obs_temp,
              sim.start="2017-06-06",
              sim.end="2017-06-15",
              plot.start="2017-06-06",
              plot.end="2017-06-15",
              plot.save=FALSE,
              min.depth = 0,max.depth = 13,by.value = 0.5)


}
