/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import java.util.logging.Logger;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.GDIObject;

public class LogBrush32
implements EMFConstants,
GDIObject {
    private int style;
    private Color color;
    private int hatch;

    public LogBrush32(int style, Color color, int hatch) {
        this.style = style;
        this.color = color;
        this.hatch = hatch;
    }

    public LogBrush32(EMFInputStream emf) throws IOException {
        this.style = emf.readUINT();
        this.color = emf.readCOLORREF();
        this.hatch = emf.readULONG();
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writeUINT(this.style);
        emf.writeCOLORREF(this.color);
        emf.writeULONG(this.hatch);
    }

    public String toString() {
        return "  LogBrush32\n    style: " + this.style + "\n    color: " + this.color + "\n    hatch: " + this.hatch;
    }

    public void render(EMFRenderer renderer) {
        if (this.style == 0) {
            renderer.setBrushPaint(this.color);
        } else if (this.style == 1) {
            renderer.setBrushPaint(new Color(0, 0, 0, 0));
        } else {
            Logger logger = Logger.getLogger("org.freehep.graphicsio.emf");
            logger.warning("LogBrush32 style not supported: " + this.toString());
            renderer.setBrushPaint(this.color);
        }
    }
}

