/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.general.PieDataset;
import org.jfree.util.PublicCloneable;

public class CustomPieURLGenerator
implements PieURLGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 7100607670144900503L;
    private ArrayList urls = new ArrayList();

    public String generateURL(PieDataset dataset, Comparable key, int pieIndex) {
        return this.getURL(key, pieIndex);
    }

    public int getListCount() {
        return this.urls.size();
    }

    public int getURLCount(int list) {
        int result = 0;
        Map urlMap = (Map)this.urls.get(list);
        if (urlMap != null) {
            result = urlMap.size();
        }
        return result;
    }

    public String getURL(Comparable key, int mapIndex) {
        Map urlMap;
        String result = null;
        if (mapIndex < this.getListCount() && (urlMap = (Map)this.urls.get(mapIndex)) != null) {
            result = (String)urlMap.get(key);
        }
        return result;
    }

    public void addURLs(Map urlMap) {
        this.urls.add(urlMap);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomPieURLGenerator) {
            CustomPieURLGenerator generator = (CustomPieURLGenerator)o;
            if (this.getListCount() != generator.getListCount()) {
                return false;
            }
            int pieItem = 0;
            while (pieItem < this.getListCount()) {
                if (this.getURLCount(pieItem) != generator.getURLCount(pieItem)) {
                    return false;
                }
                Set keySet = ((HashMap)this.urls.get(pieItem)).keySet();
                for (String key : keySet) {
                    if (this.getURL((Comparable)((Object)key), pieItem).equals(generator.getURL((Comparable)((Object)key), pieItem))) continue;
                    return false;
                }
                ++pieItem;
            }
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPieURLGenerator urlGen = new CustomPieURLGenerator();
        for (Map map : this.urls) {
            HashMap newMap = new HashMap();
            for (String key : map.keySet()) {
                newMap.put(key, map.get(key));
            }
            urlGen.addURLs(newMap);
            Object var3_4 = null;
        }
        return urlGen;
    }
}

