/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import don.Continue;
import don.Contribution;
import don.Cos2;
import don.Dimension;
import don.DonneeParse;
import don.Variable;
import ihm.Gestionnaire;
import ihm.IHM;
import ihm.PanelHabillage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PanelHabillageVariables
extends PanelHabillage {
    private JCheckBox jCheckBoxGroupe;
    private int m_type;

    public PanelHabillageVariables(Gestionnaire gestionnaire, int type) {
        super(gestionnaire);
        this.m_type = type;
        this.initialize();
    }

    public Continue getHabillageContinu() {
        if (this.jCheckBoxContinu.isSelected()) {
            if (this.jRadioButtonCos2 != null && this.jRadioButtonCos2.isSelected()) {
                return new Cos2((Dimension)this.m_gestionnaire.getAxeX(), (Dimension)this.m_gestionnaire.getAxeY());
            }
            if (this.jRadioButtonContrib.isSelected()) {
                return new Contribution((Dimension)this.m_gestionnaire.getAxeX(), (Dimension)this.m_gestionnaire.getAxeY());
            }
            return null;
        }
        return null;
    }

    public Variable getHabillageDiscret() {
        if (this.jCheckBoxGroupe.isSelected()) {
            return this.m_habilleur.getHabillageGroupe();
        }
        return null;
    }

    protected JPanel getJPanelDiscret() {
        if (this.jPanelDiscret == null) {
            GridBagConstraints gridBagConstraintsCheckBox = new GridBagConstraints();
            gridBagConstraintsCheckBox.anchor = 17;
            gridBagConstraintsCheckBox.fill = 2;
            this.jPanelDiscret = new JPanel();
            this.jPanelDiscret.setLayout(new GridBagLayout());
            this.jPanelDiscret.add((Component)this.getJCheckBoxGroupe(), gridBagConstraintsCheckBox);
        }
        return this.jPanelDiscret;
    }

    private JCheckBox getJCheckBoxGroupe() {
        if (this.jCheckBoxGroupe == null) {
            this.jCheckBoxGroupe = new JCheckBox(IHM.getXmlLangue().getElement("MgroupeHabillage"));
            this.jCheckBoxGroupe.addActionListener(this.getListener());
            this.jCheckBoxGroupe.setSelected(this.m_habilleur.getHabillageDiscret(this.getType()) != null);
            this.jCheckBoxGroupe.setEnabled(this.m_gestionnaire.getDon().getType() == DonneeParse.TypeAnalyse.MFA);
        }
        return this.jCheckBoxGroupe;
    }

    protected JPanel getJPanelTypeImpl() {
        if (this.jPanelType == null) {
            GridBagConstraints gridBagConstraintsCos2 = new GridBagConstraints();
            gridBagConstraintsCos2.anchor = 17;
            gridBagConstraintsCos2.insets = new Insets(0, 10, 0, 0);
            gridBagConstraintsCos2.gridy = 0;
            gridBagConstraintsCos2.gridx = 0;
            GridBagConstraints gridBagConstraintsContrib = new GridBagConstraints();
            gridBagConstraintsContrib.anchor = 17;
            gridBagConstraintsContrib.insets = new Insets(0, 10, 0, 0);
            gridBagConstraintsContrib.gridy = 2;
            gridBagConstraintsContrib.gridx = 0;
            this.jPanelType = new JPanel();
            this.jPanelType.setLayout(new GridBagLayout());
            if (this.m_habilleur.isHabillageCos2Possible(this.m_type)) {
                this.jPanelType.add((Component)this.getJRadioButtonCos2(), gridBagConstraintsCos2);
            }
            if (this.m_habilleur.isHabillageContribPossible(this.m_type)) {
                this.jPanelType.add((Component)this.getJRadioButtonContrib(), gridBagConstraintsContrib);
            }
            if (this.m_type == 3) {
                this.jRadioButtonContrib.setSelected(true);
            }
        }
        return this.jPanelType;
    }

    protected ActionListener getListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source.equals(PanelHabillageVariables.this.jCheckBoxContinu)) {
                    PanelHabillageVariables.this.setEnabledPanelContinu(PanelHabillageVariables.this.jCheckBoxContinu.isSelected());
                }
            }
        };
    }

    public int getType() {
        return this.m_type;
    }

    protected void setEnabledPanelContinu(boolean b) {
        super.setEnabledPanelContinu(b);
        this.setEnabledPanelStyle(false);
    }
}

