/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.CustomOverlay;
import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.HasStatistics;
import jas.hist.JASHistStyle;
import jas.hist.Statistics;
import jas.hist.XMLPrintWriter;
import jas.hist.normalization.Normalizer;
import jas.plot.LegendEntry;
import jas.plot.Overlay;
import java.util.Observable;
import java.util.Observer;

public abstract class JASHistData
extends Observable
implements Observer {
    static final long serialVersionUID = -3529869583896718619L;
    Normalizer normalization;
    int yAxisIndex;
    boolean isVisible = false;
    DataManager parent;
    private String legendText;
    private boolean showStatistics = true;
    private boolean showLegend = true;
    protected Overlay overlay;
    public static final int YAXIS_LEFT = 0;
    public static final int YAXIS_RIGHT = 1;

    JASHistData(DataManager parent) {
        this.parent = parent;
    }

    public JASHistData() {
    }

    public void show(boolean show) {
        if (show != this.isVisible) {
            this.isVisible = show;
            DataSource dataSource = this.getDataSource();
            if (dataSource instanceof Observable) {
                if (show) {
                    ((Observable)((Object)dataSource)).addObserver(this);
                    this.restoreNormalizationObserver();
                } else {
                    ((Observable)((Object)dataSource)).deleteObserver(this);
                    this.deleteNormalizationObserver();
                }
            }
            if (show) {
                this.parent.requestShow(this);
            } else {
                this.parent.requestHide(this);
            }
        }
    }

    public void setShowStatistics(boolean show) {
        this.showStatistics = show;
    }

    public boolean getShowStatistics() {
        return this.showStatistics;
    }

    public void setShowLegend(boolean show) {
        this.showLegend = show;
    }

    LegendEntry getLegendEntry() {
        if (!this.showLegend) {
            return null;
        }
        Overlay ol = this.getOverlay();
        return ol instanceof LegendEntry ? (LegendEntry)((Object)ol) : null;
    }

    abstract Overlay createOverlay();

    Overlay getOverlay() {
        if (this.overlay == null) {
            CustomOverlay co = this.getStyle().getCustomOverlay();
            if (co != null) {
                co.setDataSource(this.getDataSource());
                this.overlay = co;
            } else {
                this.overlay = this.createOverlay();
            }
        }
        return this.overlay;
    }

    public abstract DataSource getDataSource();

    public DataSource getFittableDataSource() {
        return this.getDataSource();
    }

    public abstract String getTitle();

    abstract void axisChanged();

    public abstract void setStyle(JASHistStyle var1);

    public abstract JASHistStyle getStyle();

    public void setYAxis(int i) {
        this.yAxisIndex = i;
        this.axisChanged();
    }

    public int getYAxis() {
        return this.yAxisIndex;
    }

    public void setShowing(boolean value) {
        this.show(value);
    }

    public boolean isShowing() {
        return this.isVisible;
    }

    public String toString() {
        return this.getTitle();
    }

    public void setLegendText(String text) {
        String newText = null;
        if (text.length() > 0 && !text.equals(this.getTitle())) {
            newText = text;
        }
        if (newText != this.legendText) {
            this.legendText = newText;
            this.parent.getPlot().getLegend().legendTextChanged();
        }
    }

    public String getLegendText() {
        return this.legendText != null ? this.legendText : this.getTitle();
    }

    boolean isLegendChanged() {
        return this.legendText != null;
    }

    Statistics getStatistics() {
        DataSource dataSource;
        if (this.showStatistics && (dataSource = this.getDataSource()) instanceof HasStatistics) {
            return ((HasStatistics)((Object)dataSource)).getStatistics();
        }
        return null;
    }

    abstract void writeAsXML(XMLPrintWriter var1, boolean var2);

    void deleteNormalizationObserver() {
        if (this.normalization instanceof Observable) {
            ((Observable)((Object)this.normalization)).deleteObserver(this);
        }
    }

    void restoreNormalizationObserver() {
        if (this.normalization instanceof Observable) {
            ((Observable)((Object)this.normalization)).addObserver(this);
        }
    }

    public void setNormalization(Normalizer factor) {
        if (factor != this.normalization) {
            if (this.normalization instanceof Observable) {
                ((Observable)((Object)this.normalization)).deleteObserver(this);
            }
            this.normalization = factor;
            if (factor instanceof Observable) {
                ((Observable)((Object)this.normalization)).addObserver(this);
            }
            this.normalizationChanged(true);
        }
    }

    public Normalizer getNormalization() {
        return this.normalization;
    }

    public void setXBounds(double xmin, double xmax) {
    }

    abstract void normalizationChanged(boolean var1);
}

