/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import java.lang.reflect.Constructor;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JTextFieldBinding
extends FieldBinding
implements DocumentListener {
    private String m_oldVal = "";
    private JTextField m_field;
    private byte m_flags = 0;
    public static final byte MUST_BE_NUMBER = 1;
    private static final byte MUST_BE_INTEGER_FLAG = 2;
    public static final byte MUST_BE_INTEGER = 3;
    public static final byte MUST_BE_POSITIVE = 4;

    protected JTextFieldBinding(JTextField field, byte flags) {
        this(field);
        this.m_flags = flags;
    }

    protected JTextFieldBinding(JTextField field) {
        this.m_field = field;
        field.getDocument().addDocumentListener(this);
    }

    void set(Object value) {
        String x = this.setValue(value);
        if (!this.m_oldVal.equals(x)) {
            this.m_field.setText(x);
            this.m_oldVal = x;
        }
    }

    protected String setValue(Object value) {
        String x = value == null ? "" : (value instanceof String ? (String)value : value.toString());
        return x;
    }

    protected Object getValue(String value, Class type) throws UnsupportedType {
        if (type.isPrimitive()) {
            if (type == Double.TYPE) {
                return new Double(value);
            }
            if (type == Integer.TYPE) {
                return new Integer(value);
            }
            throw new UnsupportedType(this.m_field, type);
        }
        Class[] strarg = new Class[]{value.getClass()};
        try {
            Constructor c = type.getConstructor(strarg);
            Object[] args = new Object[]{value};
            return c.newInstance(args);
        }
        catch (Exception xx) {
            throw new UnsupportedType(this.m_field, type);
        }
    }

    Object get(Class type) throws UnsupportedType {
        return this.getValue(this.m_field.getText(), type);
    }

    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    private void update() {
        String x = this.m_field.getText();
        if (!x.equals(this.m_oldVal)) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getText();
    }

    boolean hasValidInput() {
        String value = this.m_field.getText();
        if ((this.m_flags & 1) != 0) {
            try {
                double d;
                double d2 = d = (this.m_flags & 2) != 0 ? (double)Integer.parseInt(value) : Double.valueOf(value);
                if ((this.m_flags & 4) != 0 && d <= 0.0) {
                    JOptionPane.showMessageDialog(this.m_field, value.concat(" is invalid input; value must be positive."), "Error", 0);
                    return false;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.m_field, value + " is invalid input; value must be a" + ((this.m_flags & 3) != 0 ? "n integer." : " number."), "Error", 0);
                return false;
            }
        }
        return true;
    }
}

