/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.Resettable;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.menu.MenuSearchWidget;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.ThemeChangeListener;
import org.jvnet.substance.utils.LocaleChangeListener;
import org.jvnet.substance.utils.MemoryAnalyzer;

public class SubstanceMenuBarUI
extends BasicMenuBarUI {
    protected Set<?> lafWidgets;
    private static SubstanceFillBackgroundDelegate backgroundDelegate = new SubstanceFillBackgroundDelegate();
    private LocaleChangeListener substanceLocaleChangeListener;
    private ThemeChangeListener substanceThemeChangeListener;

    public static void hideSearchPanels(boolean toRepaint) {
        MenuSearchWidget.hideSearchPanels(toRepaint);
    }

    public static void showSearchPanels() {
        MenuSearchWidget.showSearchPanels();
    }

    public static ComponentUI createUI(JComponent c) {
        if (MemoryAnalyzer.isRunning()) {
            MemoryAnalyzer.enqueueUsage("SubstanceMenuBarUI to be created");
        }
        return new SubstanceMenuBarUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceThemeChangeListener = new ThemeChangeListener(){

            public void themeChanged() {
                for (LafWidget lw : SubstanceMenuBarUI.this.lafWidgets) {
                    if (!(lw instanceof Resettable)) continue;
                    ((Resettable)((Object)lw)).reset();
                }
            }
        };
        SubstanceLookAndFeel.registerThemeChangeListener(this.substanceThemeChangeListener);
        this.substanceLocaleChangeListener = new LocaleChangeListener(){

            public void localeChanged() {
                for (LafWidget lw : SubstanceMenuBarUI.this.lafWidgets) {
                    if (!(lw instanceof Resettable)) continue;
                    ((Resettable)((Object)lw)).reset();
                }
            }
        };
        SubstanceLookAndFeel.registerLocaleChangeListener(this.substanceLocaleChangeListener);
        for (LafWidget lw : this.lafWidgets) {
            lw.installListeners();
        }
    }

    protected void uninstallListeners() {
        SubstanceLookAndFeel.unregisterThemeChangeListener(this.substanceThemeChangeListener);
        this.substanceThemeChangeListener = null;
        SubstanceLookAndFeel.unregisterLocaleChangeListener(this.substanceLocaleChangeListener);
        this.substanceLocaleChangeListener = null;
        super.uninstallListeners();
        for (LafWidget lw : this.lafWidgets) {
            lw.uninstallDefaults();
        }
    }

    public void installUI(JComponent c) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (LafWidget lw : this.lafWidgets) {
            lw.installUI();
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        for (LafWidget lw : this.lafWidgets) {
            lw.installDefaults();
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        for (LafWidget lw : this.lafWidgets) {
            lw.uninstallUI();
        }
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lw : this.lafWidgets) {
            lw.uninstallDefaults();
        }
    }

    public void update(Graphics g, JComponent c) {
        boolean isOpaque = TransitionLayout.isOpaque(c);
        if (isOpaque) {
            backgroundDelegate.update(g, c);
        } else {
            super.update(g, c);
        }
    }
}

