% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dynamiteformula}
\alias{plot.dynamiteformula}
\title{Plot the Model Structure as a Directed Acyclic Graph (DAG)}
\usage{
\method{plot}{dynamiteformula}(
  x,
  show_auxiliary = TRUE,
  show_covariates = FALSE,
  tikz = FALSE,
  vertex_size = 0.25,
  label_size = 18,
  ...
)
}
\arguments{
\item{x}{[\code{dynamiteformula}]\cr The model formula.}

\item{show_auxiliary}{[\code{logical(1)}]\cr Should deterministic auxiliary
responses be shown in the plot? If \code{FALSE}, the vertices corresponding
to such responses will be projected out. The default is \code{TRUE}.}

\item{show_covariates}{[\code{logical(1)}]\cr Should unmodeled covariates be
shown in the plot? The defaults is \code{FALSE}.}

\item{tikz}{[\code{logical(1)}]\cr Should the DAG be returned in TikZ format?
The default is \code{FALSE} returning a \code{ggplot} object instead.}

\item{vertex_size}{[\code{double(1)}]\cr The size (radius) of the vertex circles
used in the \code{ggplot} DAG. (The vertical and horizontal distances between
vertices in the grid are 1, for reference.)}

\item{label_size}{[\code{double(1)}]\cr Font size (in points) to use for the
vertex labels in the \code{ggplot} DAG.}

\item{...}{Not used..}
}
\value{
A \code{ggplot} object, or a \code{character} string if \code{tikz = TRUE}.
}
\description{
Plot a snapshot of the model structure at a specific time point with
a window of the highest-order lag dependency both into the past and the
future as a directed acyclic graph (DAG). Only response variables are
shown in the plot. This function can also produce a TikZ code of the DAG
to be used in reports and publications.
}
\examples{
data.table::setDTthreads(1) # For CRAN
multichannel_formula <- obs(g ~ lag(g) + lag(logp), family = "gaussian") +
  obs(p ~ lag(g) + lag(logp) + lag(b), family = "poisson") +
  obs(b ~ lag(b) * lag(logp) + lag(b) * lag(g), family = "bernoulli") +
  aux(numeric(logp) ~ log(p + 1))
# A ggplot
plot(multichannel_formula)
# TikZ format
plot(multichannel_formula, tikz = TRUE)

}
\seealso{
Drawing plots
\code{\link{plot.dynamitefit}()}
}
\concept{plotting}
