% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.r
\name{disp_output}
\alias{disp_output}
\title{Display output of a Dynamic TOPMODEL  run}
\usage{
disp_output(qsim, rain, evap = NULL, qobs = NULL, tm = NULL, par = NULL,
  start = min(index(qsim)), end = max(index(qsim)), ...)
}
\arguments{
\item{qsim}{Time series of simulated discharges.}

\item{rain}{Time series of rainfall, at same interval as simulated values.}

\item{evap}{Time series of evapotranspiration (optional), at same interval as simulated values.}

\item{qobs}{Time series of evapotranspiration (optional), at same interval as simulated values.}

\item{tm}{Display a vertical line at this time in the simulation. If NULL no line will be drawn.}

\item{par}{Parameters controlling display output. A default set may be obtained through a call to disp.par.}

\item{start}{Start time for plot in a format interpretable as POSIXct date time. Defaults start of simulated discharges.}

\item{end}{End time for plot in a format interpretable as POSIXct date time. Defaults to end of simulated discharges.}

\item{...}{Any further named parameters will be treated as graphics parameters and applied throughout the plot.}
}
\description{
Simple output of the results of a simulation.
}
\details{
This will render the hydrograph, any observations, actual evapotranpiration, if supplied, and the rainfall hyetograph.
}
\examples{
\dontrun{
# Show the output of the storm simulation, overriding label colours and vertical axis limits.
require(dynatopmodel)

data(brompton)

x11()
with(brompton$storm.run, disp_output(evap=ae*1000,qobs=qobs*1000,
                                     qsim=qsim*1000, rain=rain*1000,
                                     max.q=2, cex.main=1, col.axis="slategrey", las.time=1))
}
}
\author{
Peter Metcalfe
}
\seealso{
disp.par
}

