% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2b_backbone_lego.R
\name{bblego}
\alias{bblego}
\alias{bblego_linear}
\alias{bblego_branching}
\alias{bblego_start}
\alias{bblego_end}
\title{Design your own custom backbone easily}
\usage{
bblego(..., .list = NULL)

bblego_linear(
  from,
  to,
  type = sample(c("simple", "doublerep1", "doublerep2"), 1),
  num_modules = sample(4:6, 1),
  burn = FALSE
)

bblego_branching(
  from,
  to,
  type = "simple",
  num_steps = 3,
  num_modules = 2 + length(to) * (3 + num_steps),
  burn = FALSE
)

bblego_start(
  to,
  type = sample(c("simple", "doublerep1", "doublerep2"), 1),
  num_modules = sample(4:6, 1)
)

bblego_end(
  from,
  type = sample(c("simple", "doublerep1", "doublerep2"), 1),
  num_modules = sample(4:6, 1)
)
}
\arguments{
\item{..., .list}{\code{bblego} components, either as separate args or as a list.}

\item{from}{The begin state of this component.}

\item{to}{The end state of this component.}

\item{type}{Some components have alternative module regulatory networks.

\code{bblego_start()}, \code{bblego_linear()}, \code{bblego_end()}:
\itemize{
\item \code{"simple"}: a sequence of modules in which every module upregulates the next module.
\item \code{"doublerep1"}: a sequence of modules in which every module downregulates the next
module, and each module has positive basal expression.
\item \code{"doublerep2"}: a sequence of modules in which every module upregulates the next
module, but downregulates the one after that.
\item \code{"flipflop"}: a sequence of modules in which every module upregulates the next module.
In addition, the last module upregulates itself and strongly downregulates the first module.
}

\code{bblego_branching()}:
\itemize{
\item \code{"simple"}: a set of \code{n} modules (with \code{n = length(to)}) which all downregulate
one another and upregulate themselves. This causes a branching to occur in the trajectory.
}}

\item{num_modules}{The number of modules this component is allowed to use.
Various components might require a minimum number of components in order to work properly.}

\item{burn}{Whether or not these components are part of the warm-up simulation.}

\item{num_steps}{The number of branching steps to reduce the odds of double positive cells occurring.}
}
\value{
A dyngen backbone.
}
\description{
You can use the \code{bblego} functions in order to create
custom backbones using various components. Please note that the \code{bblego}
functions currently only allow you to create tree-like backbones.
}
\details{
A backbone always needs to start with a single \code{bblego_start()} state and
needs to end with one or more \code{bblego_end()} states.
The order of the mentioned states needs to be such that a state is never
specified in the first argument (except for \code{bblego_start()}) before
having been specified as the second argument.
}
\examples{
backbone <- bblego(
  bblego_start("A", type = "simple", num_modules = 2),
  bblego_linear("A", "B", type = "simple", num_modules = 3),
  bblego_branching("B", c("C", "D"), type = "simple", num_steps = 3),
  bblego_end("C", type = "flipflop", num_modules = 4),
  bblego_end("D", type = "doublerep1", num_modules = 7)
)
}
