\name{WBC measurements data}

\docType{data}

\alias{wbc2}

\title{Data from the Benelux CML study}

\description{A data frame of 210 patients with Chronic Myeloid Leukemia from the
Benelux CML study (Kluin-Nelemans et al. 1998). Data have been used in two
methodological papers, de Bruijne et al. (2001) and van Houwelingen (2007), and
in the book van Houwelingen \& Putter (2011), especially Chapter 8. More
background is given in Appendix A.2 of van Houwelingen \& Putter (2011). Interest
is in the time-dependent covariate White Blood Cell count (WBC). Data set
\code{\link{wbc1}} contains the follow-up data and time-fixed covariates, while
wbc2 contains the WBC measurements.
The included variables in wbc2 are
  \describe{
  \item{patnr}{Patient identification number}
  \item{tyears}{Time of WBC measurement in years from randomization}
  \item{lwbc}{Log-transformed and standardized WBC measurement, more precisely,
  defined as lwbc=log10(wbc)-0.95}
  }
}

\usage{data(wbc2)}

\format{A data frame, see \code{\link{data.frame}}.}

\references{
Kluin-Nelemans JC, Delannoy A, Louwagie A, le Cessie S, Hermans J,
van der Burgh JF, Hagemeijer AM, van den Berghe H \& Benelux CML Study Group
(1998). Randomized study on hydroxyurea alone versus hydroxyurea combined with
low-dose interferon-alpha 2b for chronic myeloid leukemia. \emph{Blood}
\bold{91}, 2713--2721.

de Bruijne MHJ, le Cessie S, Kluin-Nelemans HC \& van Houwelingen HC (2001).
On the use of Cox regression in the presence of an irregularly observed
time-dependent covariate. \emph{Statistics in Medicine} \bold{20}, 3817--3829.

van Houwelingen HC (2007). Dynamic prediction by landmarking in event history
analysis. \emph{Scandinavian Journal of Statistics} \bold{34}, 70--85.

van Houwelingen HC, Putter H (2011). Dynamic Predicting in Clinical Survival
Analysis. Chapman \& Hall.
}

\keyword{datasets}
