% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{printex}
\alias{printex}
\alias{printex,dynrCook-method}
\alias{printex,dynrDynamicsFormula-method}
\alias{printex,dynrDynamicsMatrix-method}
\alias{printex,dynrInitial-method}
\alias{printex,dynrMeasurement-method}
\alias{printex,dynrModel-method}
\alias{printex,dynrNoise-method}
\alias{printex,dynrRegimes-method}
\title{The printex Method}
\usage{
printex(object, ParameterAs, printDyn = TRUE, printMeas = TRUE,
  printInit = FALSE, printRS = FALSE, outFile, show, ...)
}
\arguments{
\item{object}{The dynr object (recipe, model, or cooked model).}

\item{ParameterAs}{The parameter values or names to plot. The underscores in parameter names are 
saved for use of subscripts.  Greek letters can be specified as corresponding LaTeX symbols without ##' backslashes (e.g., "lambda") and printed as greek letters.}

\item{printDyn}{logical. Whether or not to print the dynamic model. The default is TRUE.}

\item{printMeas}{logical. Whether or not to print the measurement model. The default is TRUE.}

\item{printInit}{logical. Whether or not to print the initial conditions. The default is FALSE.}

\item{printRS}{logical. Whether or not to print the regime-switching model. The default is FALSE.}

\item{outFile}{The name of the output tex file.}

\item{show}{logical indicator of whether or not to show the result in the console.}

\item{...}{Further named arguments, passed to internal method. 
\code{AsMatrix} is a logical indicator of whether to put the object in matrix form.}
}
\description{
The printex Method
}
\details{
This is a general way of getting a LaTeX string for recipes, 
models, and cooked models.  It is a great way to check that 
you specified the model or recipe you think you did before 
estimating its free parameters (cooking).  After the model 
is cooked, you can use it to get LaTeX code with the estimated 
parameters in it.

Typical inputs to the \code{ParameterAs} argument are (1) the starting values for a model, (2) the final estimated values for a model, and (3) the parameter names.  These are accessible with (1) \code{model$xstart}, (2) \code{coef(cook)}, and (3) \code{model$param.names} or \code{names(coef(cook))}, respectively.
}
\seealso{
A way to put this in a plot with \code{\link{plotFormula}}
}

