% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrGetDerivs.R
\name{dynr.flowField}
\alias{dynr.flowField}
\title{A Function to plot the flow or velocity field for a one or two dimensional 
autonomous ODE system from the phaseR package written by Michael J. Grayling.}
\usage{
dynr.flowField(deriv, xlim, ylim, parameters = NULL, system = "two.dim",
  points = 21, col = "gray", arrow.type = "equal", arrow.head = 0.05,
  frac = 1, add = TRUE, xlab = "x", ylab = "y", state.names = c("x",
  "y"), ...)
}
\arguments{
\item{deriv}{A function computing the derivative at a point for the ODE system 
to be analysed. For examples see the phaseR package guide.}

\item{xlim}{A vector of length two setting the lower and upper limits of the variable 
to be plotted on the horizontal axis (usually the first variable returned by the function deriv)}

\item{ylim}{A vector of length two setting the lower and upper limits of the variable 
to be plotted on the vertical axis (usually the second variable returned by the function deriv)}

\item{parameters}{Parameters of the ODE system, to be passed to deriv. 
Supplied as a vector; the order of the parameters can be found from the 
deriv file. Defaults to NULL.}

\item{system}{Set to either "one.dim" or "two.dim" to indicate the type of system 
being analysed. Defaults to "two.dim".}

\item{points}{Sets the density of the line segments to be plotted. Defaults to 11.}

\item{col}{Sets the color of the plotted line segments. Defaults to "gray". 
Should be a vector of length one. Will be reset accordingly if it is a vector of the wrong length.}

\item{arrow.type}{Sets the type of line segments plotted. Options include:
"proportional" = the length of the line segments reflects the magnitude of the derivative. 
"equal" the line segments take equal lengths, simply reflecting the gradient of 
the derivative(s). Defaults to "equal".}

\item{arrow.head}{Sets the length of the arrow heads. Passed to arrows. Defaults to 0.05.}

\item{frac}{Sets the fraction of the theoretical maximum length line segments can take 
without overlapping, that they can actually attain. In practice, frac can be set to greater 
than 1 without line segments overlapping.}

\item{add}{Logical. Defaults to TRUE.
TRUE = the flow field is added to an existing plot; FALSE = a new plot is created.}

\item{xlab}{Label for the x-axis of the resulting plot. Defaults to "x".}

\item{ylab}{Label for the y-axis of the resulting plot. Defaults to "y".}

\item{state.names}{State names for ode functions that do not use positional states}

\item{...}{Additional arguments to be passed to either plot or arrows.}
}
\value{
Returns a list with the following components:
add, arrow.head, arrow.type, col, deriv, dx, dy, frac, parameters, points,
system, x, xlab, xlim, y, ylab, ylim. Most of these components correspond simply
to their original input values. 

The only new elements are:

dx = A matrix. In the case of a two dimensional system, the values of the 
derivative of the first dependent derivative at all evaluated points.

dy = A matrix. In the case of a two dimensional system, the values of the derivative of the second dependent variable at all evaluated points. In the case of a one dimensional system, the values of the derivative of the dependent variable at all evaluated points.

x	= A vector. In the case of a two dimensional system, the values of the first dependent variable at which the derivatives were computed. In the case of a one dimensional system, the values of the independent variable at which the derivatives were computed.

y	= A vector. In the case of a two dimensional system, the values of the second dependent variable at which the derivatives were computed. In the case of a one dimensional system, the values of the dependent variable at which the derivatives were computed.
}
\description{
A Function to plot the flow or velocity field for a one or two dimensional 
autonomous ODE system from the phaseR package written by Michael J. Grayling.
}
\note{
The phaseR package was taken off cran as off 10/1/2019 so we are 
exporting some selected functions from phaseR_2.0 published on 8/20/2018.
For details of these functions please see original documentations on the
phaseR package.
}
\examples{
#Osc <- function(t, y, parameters) {
#  dy <- numeric(2)
#  dy[1] <- y[2]
#  dy[2] <- parameters[1]*y[1]+parameters[2]*dy[1]   
#  return(list(dy))
#}
#
#param <- coef(g)
#dynr.flowField(Osc, xlim = c(-3, 3), 
#                  ylim = c(-3, 3),
#                  xlab="x", ylab="dx/dt",
#                  main=paste0("Oscillator model"),
#                  cex.main=2,
#                  parameters = param, 
#                  points = 15, add = FALSE,
# col="blue",
# arrow.type="proportional",
# arrow.head=.05)  
}
\references{
Grayling, Michael J. (2014). phaseR: An R Package for Phase Plane Analysis of Autonomous
ODE Systems. The R Journal, 6(2), 43-51. DOI: 10.32614/RJ-2014-023. Available at
https://doi.org/10.32614/RJ-2014-023
}

