% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survCurv.R
\name{survCurve}
\alias{survCurve}
\title{Estimated Survival Function or Cumulative Hazard Function}
\usage{
survCurve(
  object,
  newdata,
  type = c("survival", "cumhaz"),
  level = 0.95,
  centered = FALSE,
  ...
)
}
\arguments{
\item{object}{An object returned by function \code{bayesCox}.}

\item{newdata}{An optional data frame used to generate a design matrix.}

\item{type}{An optional character value indicating the type of function to
compute. The possible values are "survival" and "cumhaz". The former
means the estimated survival function; the latter represents the
estimated cumulative hazard function for the given \code{newdata}.}

\item{level}{A numerical value between 0 and 1 indicating the level of
cradible band.}

\item{centered}{A logical value. If \code{TRUE}, the mean function for the
given \code{newdata} will be computed. The default is \code{FALSE}.}

\item{...}{Other arguments for further usage.}
}
\value{
A data frame with column: "Low", "Mid", "High", "Time", "Design",
    and "type", and attribute, "surv" valued as "survCurve".
}
\description{
Estimated survival function or cumulative hazard function from posterior
sample for an object returned by function \code{bayesCox}.
}
\details{
The estimated survival curve is a step function representing the posterior
mean survival proportion at the given time grid from the posterior sample.
The credible interval for the survival curve is constructed based on the
quantiles of all the survival curves from posterior sample at given credible
level. More details were available in Section posterior computation of Wang
(2016).
}
\examples{
## See the examples in bayesCox.

}
\references{
Wang, W., Chen, M. H., Chiou, S. H., Lai, H. C., Wang, X., Yan, J.,
& Zhang, Z. (2016). Onset of persistent pseudomonas aeruginosa infection in
children with cystic fibrosis with interval censored data.
\emph{BMC Medical Research Methodology}, 16(1), 122.
}
\seealso{
\code{\link{bayesCox}},
\code{\link{survDiff}}, and
\code{\link{plotSurv}}.
}
