% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_mean.R
\name{calculate_mean}
\alias{calculate_mean}
\alias{calculate_harmonic_mean}
\alias{calculate_geometric_mean}
\alias{calculate_arithmetic_mean}
\title{Calculate a (weighted) mean between vectors or a list of vectors}
\usage{
calculate_mean(..., method, weights = NULL)

calculate_harmonic_mean(..., weights = NULL)

calculate_geometric_mean(..., weights = NULL)

calculate_arithmetic_mean(..., weights = NULL)
}
\arguments{
\item{...}{Can be:
- One numeric vector
- A list containg numeric vectors
- Numeric vectors given as separate inputs}

\item{method}{The aggregation function. Must be one of `"arithmetic"`, `"geometric"`, and `"harmonic"`.}

\item{weights}{Weights with the same length as `...`.}
}
\description{
This function supports the arithmetic, geometric and harmonic mean.
}
\examples{
calculate_arithmetic_mean(0.1, 0.5, 0.9)
calculate_geometric_mean(0.1, 0.5, 0.9)
calculate_harmonic_mean(0.1, 0.5, 0.9)
calculate_mean(.1, .5, .9, method = "harmonic")

# example with multiple vectors
calculate_arithmetic_mean(c(0.1, 0.9), c(0.2, 1))

# example with a list of vectors
vectors <- list(c(0.1, 0.2), c(0.4, 0.5))
calculate_geometric_mean(vectors)

# example of weighted means
calculate_geometric_mean(c(0.1, 10), c(0.9, 20), c(0.5, 2), weights = c(1, 2, 5))
}
