% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Para.r
\name{Para}
\alias{Para}
\alias{Para.HOF}
\alias{Para.HOF.list}
\title{Curve parameters of eHOF models}
\usage{
Para(resp, ...)

\method{Para}{HOF}(resp, model, newdata = NULL, ...)
}
\arguments{
\item{resp}{response model results, see [HOF()]}

\item{\dots}{further arguments passed to or from other methods, e.g. for [pick.model()]}

\item{model}{response model type. If not specified, the output of [pick.model()] will be used}

\item{newdata}{vector of gradient values to use}
}
\value{
* species Name or abbreviat of the species.
 * abund sum Abundance sum, i.e. sum of all response values divided by M.
* range Range of x values.
* model Model type, if not specified the result of [pick.model].
* para Model parameters (a to d).
* M Maximum response value, specified in the HOF function call.
* mini Location of the minimum, i.e. the gradient value, where the response is lowest, for model VI and VII the lowest response between the two optima.
* pess Lowest estimated response value.
* top Highest estimated response value(s).
* opt Location of the optimum, i.e. the gradient value, where the species response is highest. NA for model I and an optimum interval for model type III.
* expect  Expectancy value, i.e. average x value under the model curve).
* max slope Highest slope, i.e. maximum of the first derivation of the curve.
* centralBorder Following Heegard, the central borders are calculated as the gradient values, where the response reaches \code{"exp(-1/2)"} of the top.
* outerBorder Following Heegard, the outer borders of the species niche are calculated as the gradient values, where the response reaches \code{exp(-2)} of the top.
* raw mean Average of measured x values.
}
\description{
Derive common shape parameters from the different model types.
  Calculate a set of parameters (see values below) from eHOF models.
}
\details{
For models VI and VII \code{Para} will give you two expectancy values for the ranges left and right of the pessimum between the model optima. If you want to have the overall expectancy value, use:
    \code{
      gradient <- seq(min(Para(resp)$range), max(Para(resp)$range), length.out=10000)
      weighted.mean(gradient, predict(resp, newdata=gradient))
    }
}
\references{
Heegard, E. (2002) The outer border and central border for species-environmental relationships estimated by non-parametric generalised additive models. Ecological Modelling, 157, 131-139.

  Damgaard, C. (2006) Modelling ecological presence-absence data along an environmental gradient: threshold levels of the environment. Environ Ecol Stat 13:229-236.
}
\author{
Florian Jansen
}
\keyword{models}
