% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext.R
\name{TimeSurvProb}
\alias{TimeSurvProb}
\title{Predict cumulative survival probabilities for new data at given time points}
\usage{
TimeSurvProb(fit, time, event, olddata, newdata, s, times = c(1:36) * 30.5,
  plot = FALSE)
}
\arguments{
\item{fit}{A single regularized Cox regression model fitted using glmnet}

\item{time}{Time to events for the training data}

\item{event}{Event indicators for the training data (0 censored, 1 event)}

\item{olddata}{The old data matrix used to fit the original 'fit' glmnet-object}

\item{newdata}{The new data matrix for which to predict time-to-event prediction (should comform to the old data matrix)}

\item{s}{The optimal lambda parameter as used in the glmnet-package for its fit objects}

\item{times}{The time points at which to estimate the cumulative survival probabilities (by default in days)}

\item{plot}{Should the cumulative survival probabilities be plotted as a function of time}
}
\value{
Cumulative survival probabilities at the chosen time points
}
\description{
Given a readily fitted regularized Cox regression model, this function predicts the cumulative survival probabilities for new data at time points determined by the user. The function uses c060-package's functionality for computing base hazard, and then performs linear predictions for new observations using the fitted regularized Cox regression model.
}
\author{
Teemu Daniel Laajala \email{teelaa@utu.fi}
}
