% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{bootstrapRegCoefs}
\alias{bootstrapRegCoefs}
\title{Bootstrapped testing of regression coefficients in a penalized model}
\usage{
bootstrapRegCoefs(fit, lambda, boot = 1000, epsilon = 10^-6)
}
\arguments{
\item{fit}{A regularized regression model fit as provided by the glmnet-package}

\item{lambda}{The pre-fixed corresponding optimal lambda value, typically determined using cross-validation (e.g. cv.glmnet$lambda.1se or cv.glmnet$lambda.min in glmnet)}

\item{boot}{The number of bootstrapped datasets to generate}

\item{epsilon}{The tolerance around beta = 0 to still count estimates as zero}
}
\value{
Significance values for regression coefficients, defined as the proportion of bootstrapped model fits where coefficient did not shrink within epsilon of zero or where it did not flip sign.
}
\description{
The purpose of this function is to evaluate a p-value-like statistic for penalized regression coefficients. A fixed number of bootstrapped datasets are generated, and the model coefficients are fitted to these bootstrapped datasets using the pre-determined lambda.
}
\note{
Notice that this is a highly experimental function, and that many statisticians argue that computing p-values does not make sense for penalized models. The null hypothesis is not well defined, as the bias (regularization) pushes the regression coefficients towards zero. Therefore the null hypothesis is not known and the interpretation is not the conventional regression coefficient p-value.
}
\examples{
\dontrun{
# Computationally too intensive to run bootstrapped fits <5s
data(TYKSSIMU)
library(survival)
x <- as.matrix(xMEDISIMU)
y <- yMEDISIMU[,"surv"]
nlambda <- 30
psp1 <- new("PSP", alphaseq=c(0, 0.5, 1), nlambda = nlambda, folds = 3, x = x, y = y, seeds = 1)
.Object <- psp1
alphaopt <- psp1@optimum["Alpha"]
bs <- bootstrapRegCoefs(fit = psp1@fit, lambda = psp1@optimum["Lambda"], boot = 100)
# Histogram of bootstrapped ps
hist(bs$ps, breaks=100)
}
}
