% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{cv.grid}
\alias{cv.grid}
\title{Cross-validation runs for risk predition for a grid of predetermined alpha values and their conditional lambda values}
\usage{
cv.grid(alphaseq = seq(from = 0, to = 1, by = 0.1), seed, x, y,
  folds = 10, nlamb = 100, verb = 0, scorefunc, plot = FALSE)
}
\arguments{
\item{alphaseq}{Sequence of alpha values to test, which should be within [0,1] (with alpha = 0 being ridge regression, 0 < alpha < 1 being elastic net, and alpha = 1 being LASSO)}

\item{seed}{Random number generation seed for reproducibility}

\item{x}{Data matrix x}

\item{y}{The Surv-object response y}

\item{folds}{Number of folds in the cross-validation}

\item{nlamb}{Number of lambda values to test in each alpha; notice that these lambda values vary conditional to alpha}

\item{verb}{Level of verbosity, with 0 as silent and 1 with additional output}

\item{scorefunc}{Chosen scoring function, e.g. score.cindex or score.iAUC}

\item{plot}{Whether a performance should be plotted at each varying alpha-value similar to cv.alpha-plots}
}
\value{
List of matrices of cross-validation performance values over the alpha/lambda grid for mean/median/min/max/stdev of the chosen performance metric, with rows indicating various alpha-values and columns indicating lambda-values.
}
\description{
Expanded Cross-Validation function to run the whole CV in the lambda/alpha grid instead of just lambda-sequence with a pre-specified alpha
}
\examples{
data(TYKSSIMU)
library(survival)
ydat <- Surv(event = yMEDISIMU[,"DEATH"], time = yMEDISIMU[,"LKADT_P"])
cvs <- cv.grid(x = xMEDISIMU, y = ydat, folds = 3, nlamb = 30, alphaseq = seq(0, 1, by=5), 
	scorefunc = score.iAUC, plot = TRUE, seed = 1)
cvs
}
