\name{rsctrl}
\alias{rsctrl}
\title{Controls for the Sampling Function}
\description{

  Various parameters that control aspects of
  the random generation of binary matrices.
}
\usage{
rsctrl(burn_in = 100, n_eff = 100, step = 16, seed = 0, tfixed = FALSE)
}
\arguments{
  \item{burn_in}{
      the number of sampled matrices to
      come close to a stationary distribution.
      The default is \code{burn_in = 100}.
      (The actual number is \code{2 * burn_in * step}.)
      }
  \item{n_eff}{
      the number of effective matrices, i.e.,
      the number of matrices
      to be generated by the sampling function \code{\link{rsampler}}.
      \code{n_eff} must be positive and not larger than 8191
      (2\eqn{\mbox{\textasciicircum}}{^}13-1).
      The default is \code{n_eff = 100}.
      }
  \item{step}{controls the number number of void matrices generated in the the burn in
                process and when effective matrices are generated (see note
                below). The default is \code{step = 16}. }
  \item{seed}{
      is the indicator for the seed of the random number generator. 
      Its value must be in the range 0 and 2147483646 (2**31-2).
      If the value of seed equals zero, a seed is generated
      by the sampling function \code{\link{rsampler}}
      (dependent on the system's clock) and its value is returned
      in the output. If seed is not equal to zero, its 
      value is used as the seed of the random number generator.
      In that case its value is unaltered at output.
      The default is \code{seed = 0}.
      }
  \item{tfixed}{logical, -- specifies if in case of a quadratic input
      matrix the diagonal is considered fixed (see note below).
      The default is \code{tfixed = FALSE}.
      }
}

\value{
  A list of class \code{RSctr} with components
 \code{burn_in}, \code{n_eff}, \code{step},
 \code{seed}, \code{tfixed}.,
}
\note{
   If one of the components is incorrectly specified
   the error function \code{rserror}
   is called and some informations are printed. The ouput object
   will not be defined.\cr\cr
   The specification of \code{step} controls the sampling algorithm as follows:
   If , e.g., \code{burn_in = 10}, \code{n_eff = 5}, and \code{step = 2},
   then during the burn in period \code{step * burn_in = 2 * 10}
   matrices are generated. After that, \code{n_eff * step = 5 * 2} matrices
   are generated and every second matrix of these last ten is returned from
   \code{link{rsampler}}.\cr\cr
   \code{tfixed} has no effect if the input matrix is not quadratic,
      i.e., all matrix elements are considered free (unrestricted).
      If the input matrix is quadratic, and \code{tfixed = TRUE},
      the main diagonal of the matrix is considered as fixed.
      On return from \code{link{rsampler}} all diagonal elements
      of the generated matrices are set to zero.
      This specification applies, e.g.,
      to analyzing square incidence matrices
      representing binary asymmetric relation
      in social network theory.\cr\cr
   The summary method (\code{\link{summary.RSctr}}) prints
   the current definitions. \cr
}
\seealso{\code{\link{rsampler}} }
\examples{
ctr <- rsctrl(n_eff = 1, seed = 987654321)  # specify new controls
summary(ctr)

\dontrun{
# incorrect specifications will lead to an error
ctr2 <- rsctrl(step = -3, n_eff = 10000)}
}

\keyword{misc}
