\encoding{utf8}
\name{eaf-package}
\alias{eaf-package}
\alias{eaf}
\docType{package}
\title{
Plots of the Empirical Attainment Function
}
\description{
  The empirical attainment function (EAF) describes the probabilistic
  distribution of the outcomes obtained by a stochastic algorithm in the
  objective space. This package implements plots of summary
  attainment surfaces and differences between the first-order
  EAFs. These plots may be used for exploring the performance of
  stochastic local search algorithms for biobjective optimization
  problems and help in identifying certain algorithmic behaviors in a
  graphical way. 
}
\details{
  %%~~ An overview of how to use the package, including the most important functions ~~
\tabular{ll}{
Package: \tab eaf\cr
Type: \tab Package\cr
Version: \tab 1.06 \cr
Date: \tab 2014-09-30 \cr
Depends: \tab R (>= 2.10.0)\cr
Imports: \tab modeltools\cr
Suggests: \tab \cr
License: \tab GPL (>= 2)\cr
URL: \tab http://iridia.ulb.ac.be/~manuel/eaftools\cr
LazyLoad: \tab yes\cr
%Built: \tab R 2.11.1; universal-apple-darwin9.8.0; 2010-09-12 19:30:09 UTC; unix\cr
}

Functions:

\tabular{rl}{
\code{\link{eafdiffplot}} \tab  Empirical attainment function differences\cr
\code{\link{eafplot}} \tab  Plot the Empirical Attainment Function for two
objectives\cr
\code{\link{read.data.sets}}\tab  Read several data.frame sets\cr
}

Data:

\describe{
\item{\code{\link{gcp2x2}}}{  Metaheuristics for solving the Graph Vertex Coloring Problem}
\item{\code{\link{HybridGA}}}{  Results of Hybrid GA on vanzyl and Richmond
water networks}
\item{\code{\link{SPEA2minstoptimeRichmond}}}{ Results of SPEA2 when minimising electrical cost and maximising the
minimum idle time of pumps on Richmond water network}
}


Extras are available at \code{file.path(system.file(package="eaf"))}:

\tabular{ll}{

\code{extdata}        \tab  External data sets (see \code{\link{read.data.sets}})\cr
\code{scripts/eaf}    \tab  EAF command-line program\cr
\code{scripts/eafplot}\tab  Perl script to generate plots of attainment surfaces\cr
\code{scripts/eafdiff}\tab  Perl script to generate plots of EAF differences\cr
}
}
\author{
  Maintainer:  Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
  \email{manuel.lopez-ibanez@ulb.ac.be}

  Contributors: Carlos Fonseca, Luis Paquete, Thomas \enc{Stützle}{Stuetzle}, 
  Manuel \enc{López-Ibáñez}{Lopez-Ibanez} and Marco Chiarandini.
%%~~ The author and/or maintainer of the package ~~
}
\references{
  V. Grunert da Fonseca, C. M. Fonseca, and A. O. Hall, \emph{Inferential
  performance assessment of stochastic optimisers and the attainment
  function}, in Evolutionary Multi-Criterion Optimization. First
  International Conference, EMO 2001 (E. Zitzler, K. Deb, L. Thiele,
  C. A. Coello Coello, and D. Corne, eds.), vol. 1993 of Lecture Notes
  in Computer Science, pp. 213-225, Berlin: Springer, 2001.

  V. Grunert da Fonseca and C. M. Fonseca, \emph{The attainment-function
  approach to stochastic multiobjective optimizer assessment and
  comparison}. In T. Bartz-Beielstein, M. Chiarandini, L. Paquete, and
  M. Preuss, editors, Experimental Methods for the Analysis of
  Optimization Algorithms, pages 103-130, Springer, Berlin, Germany,
  2010.
  
  M. \enc{López-Ibáñez}{Lopez-Ibanez}, L. Paquete, and T. \enc{Stützle}{Stuetzle}. \emph{Exploratory
  Analysis of Stochastic Local Search Algorithms in Biobjective
  Optimization}. In T. Bartz-Beielstein, M. Chiarandini, L. Paquete, and
  M. Preuss, editors, Experimental Methods for the Analysis of
  Optimization Algorithms, pages 209–222. Springer, Berlin, Germany,
  2010. doi: 10.1007/978-3-642-02538-9_9
  
%%~~ Literature or other references for background information ~~
}
%%~~ Optionally other standard keywords, one per line, from file KEYWORDS in the R documentation directory ~~
\keyword{package}
\keyword{graphs}
\keyword{multivariate}
\keyword{optimize}
\keyword{Time-quality algorithm profile}
\keyword{Empirical attainment function }

% \seealso{
% %%~~ Optional links to other man pages, e.g. ~~
% %%~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
% }
\examples{
data(gcp2x2)
tabucol<-subset(gcp2x2, alg!="TSinN1")
tabucol$alg<-tabucol$alg[drop=TRUE]
eafplot(time+best~run,data=tabucol,subset=tabucol$inst=="DSJC500.5")

eafplot(time+best~run|inst,groups=alg,data=gcp2x2)
eafplot(time+best~run|inst,groups=alg,data=gcp2x2,
	percentiles=c(0,50,100),include.extremes=TRUE,
	cex=1.4, lty=c(2,1,2),lwd=c(2,2,2),
        col=c("black","blue","grey50"))

A1<-read.data.sets(file.path(system.file(package="eaf"),"extdata","ALG_1_dat"))
A2<-read.data.sets(file.path(system.file(package="eaf"),"extdata","ALG_2_dat"))
eafplot(A1,A2, percentiles=c(50))
eafplot(list(A1=A1, A2=A2), percentiles=c(50))
eafdiffplot(A1, A2)
\dontrun{dev.copy2pdf(file="eaf.pdf", onefile=TRUE, width=5, height=4)}
}

%
%if (.Platform$OS.type=="unix")
%{
%} else {
%A1<-gcp2x2[gcp2x2$alg=="TSinN1" & gcp2x2$inst=="DSJC500.5",]
%A2<-gcp2x2[gcp2x2$alg=="SAKempeFI" & gcp2x2$inst=="DSJC500.5",]
%eafdiffplot(A1[,c(5,4,3)],A2[,c(5,4,3)],full.eaf=TRUE)
%}