% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplot.R
\name{qqplot}
\alias{qqplot}
\title{Log QQ p-value plot}
\usage{
qqplot(
  pval,
  fdr = NULL,
  fdr_cutoff = 0.05,
  scheme = c("darkgrey", "royalblue"),
  npoints = 5e+05,
  show_plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{pval}{A vector of p-values}

\item{fdr}{An optional vector of FDR values to save time if previously
computed. If not supplied, these will be calculated using \code{\link[=p.adjust]{p.adjust()}}
using the Benjamini-Hochberg method.}

\item{fdr_cutoff}{Cutoff for FDR significance}

\item{scheme}{Vector of 2 colours for plotting non-significant and
significant SNPs}

\item{npoints}{Limits the number of non-significant points being plotted to
speed up plotting. See details. Set to \code{NULL} to plot all points.}

\item{show_plot}{Logical whether to produce a plot via base graphics or just
return dataframe ready for plotting.}

\item{verbose}{Whether to show messages}

\item{...}{Optional plotting arguments passed to \code{\link[=qqplot2]{qqplot2()}}}
}
\value{
Generates a plot using base graphics. Also returns a dataframe
invisibly which can be used for downstream plotting via either \code{\link[=qqplot2]{qqplot2()}}
or \code{\link[=gg_qqplot]{gg_qqplot()}}.
}
\description{
Fast function for generating a log quantile-quantile (QQ) p-value plot
}
\details{
Produces a fast QQ plot. Particularly useful for analyses with very large
numbers of p-values (such as eQTL analysis) which can be slow to plot. The
function looks first for all comparisons which reached FDR at the designated
cut-off and ensures all of these points are plotted. Additional points which
typically overlap substantially near the origin are thinned by random
sampling. In this way the plot can be reduced from millions of points to
500,000 points with a plot which is indistinguishable from one with all
points plotted. For comparison, set \code{npoints} to \code{NULL} to plot all points as
usual.

Calling \code{\link[=qqplot]{qqplot()}} will result in a base graphics plot. The plotting
dataframe is returned invisibly, so users can save time when refining plots
by saving the dataframe produced by \code{\link[=qqplot]{qqplot()}} and then invoking \code{\link[=qqplot2]{qqplot2()}}
to simply plot the points. Users who prefer ggplot2 can also pass the
dataframe generated by \code{\link[=qqplot]{qqplot()}} to \code{\link[=gg_qqplot]{gg_qqplot()}}.
}
\seealso{
\code{\link[=qqplot2]{qqplot2()}} \code{\link[=gg_qqplot]{gg_qqplot()}}
}
