% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{easy_analysis}
\alias{easy_analysis}
\title{The core recipe of easyml.}
\usage{
easy_analysis(.data, dependent_variable, algorithm, family = "gaussian",
  resample = NULL, preprocess = NULL, measure = NULL,
  exclude_variables = NULL, categorical_variables = NULL,
  train_size = 0.667, foldid = NULL, survival_rate_cutoff = 0.05,
  n_samples = 1000, n_divisions = 1000, n_iterations = 10,
  random_state = NULL, progress_bar = TRUE, n_core = 1,
  coefficients = NULL, variable_importances = NULL, predictions = NULL,
  model_performance = NULL, model_args = list())
}
\arguments{
\item{.data}{A data.frame; the data to be analyzed.}

\item{dependent_variable}{A character vector of length one; the dependent variable for this analysis.}

\item{algorithm}{A character vector of length one; the algorithm to run on the data. Choices are currently one of c("deep_neural_network", "glinternet", "glmnet", "neural_network", "random_forest", "support_vector_machine").}

\item{family}{A character vector of length one; the type of regression to run on the data. Choices are one of c("gaussian", "binomial"). Defaults to "gaussian".}

\item{resample}{A function; the function for resampling the data. Defaults to NULL.}

\item{preprocess}{A function; the function for preprocessing the data. Defaults to NULL.}

\item{measure}{A function; the function for measuring the results. Defaults to NULL.}

\item{exclude_variables}{A character vector; the variables from the data set to exclude. Defaults to NULL.}

\item{categorical_variables}{A character vector; the variables that are categorical. Defaults to NULL.}

\item{train_size}{A numeric vector of length one; specifies what proportion of the data should be used for the training data set. Defaults to 0.667.}

\item{foldid}{A vector with length equal to \code{length(y)} which identifies cases belonging to the same fold.}

\item{survival_rate_cutoff}{A numeric vector of length one; for \code{\link{easy_glmnet}}, specifies the minimal threshold (as a percentage) a coefficient must appear out of n_samples. Defaults to 0.05.}

\item{n_samples}{An integer vector of length one; specifies the number of times the coefficients and predictions should be generated. Defaults to 1000.}

\item{n_divisions}{An integer vector of length one; specifies the number of times the data should be divided when replicating the measures of model performance. Defaults to 1000.}

\item{n_iterations}{An integer vector of length one; during each division, specifies the number of times the predictions should be generated. Defaults to 10.}

\item{random_state}{An integer vector of length one; specifies the seed to be used for the analysis. Defaults to NULL.}

\item{progress_bar}{A logical vector of length one; specifies whether to display a progress bar during calculations. Defaults to TRUE.}

\item{n_core}{An integer vector of length one; specifies the number of cores to use for this analysis. Currently only works on Mac OSx and Unix/Linux systems. Defaults to 1.}

\item{coefficients}{A logical vector of length one; whether or not to generate coefficients for this analysis.}

\item{variable_importances}{A logical vector of length one; whether or not to generate variable importances for this analysis.}

\item{predictions}{A logical vector of length one; whether or not to generate predictions for this analysis.}

\item{model_performance}{A logical vector of length one; whether or not to generate measures of model performance for this analysis.}

\item{model_args}{A list; the arguments to be passed to the algorithm specified.}
}
\value{
A list of class \code{easy_*}, where * is the name of the algorithm.
\describe{
\item{call}{An object of class \code{call}; the original function call.}
\item{data}{A data.frame; the original data.}
\item{dependent_variable}{A character vector of length one; the dependent variable for this analysis.}
\item{algorithm}{A character vector of length one; the algorithm to run on the data.}
\item{class}{A character vector of length one; the class of the object.}
\item{family}{A character vector of length one; the type of regression to run on the data. Choices are one of c("gaussian", "binomial"). Defaults to "gaussian".}
\item{resample}{A function; the function for resampling the data.}
\item{preprocess}{A function; the function for preprocessing the data.}
\item{measure}{A function; the function for measuring the results.}
\item{exclude_variables}{A character vector; the variables from the data set to exclude.}
\item{train_size}{A numeric vector of length one; specifies what proportion of the data should be used for the training data set.}
\item{survival_rate_cutoff}{A numeric vector of length one; for \code{\link{easy_glmnet}}, specifies the minimal threshold (as a percentage) a coefficient must appear out of n_samples.}
\item{n_samples}{An integer vector of length one; specifies the number of times the coefficients and predictions should be generated.}
\item{n_divisions}{An integer vector of length one; specifies the number of times the data should be divided when generating measures of model performance.}
\item{n_iterations}{An integer vector of length one; during each division, specifies the number of times the predictions should be generated.}
\item{random_state}{An integer vector of length one; specifies the seed to be used for the analysis.}
\item{progress_bar}{A logical vector of length one; specifies whether to display a progress bar during calculations.}
\item{n_core}{An integer vector of length one; specifies the number of cores to use for this analysis.}
\item{generate_coefficients}{A logical vector of length one; whether or not to generate coefficients for this analysis.}
\item{generate_variable_importances}{A logical vector of length one; whether or not to generate variable importances for this analysis.}
\item{generate_predictions}{A logical vector of length one; whether or not to generate predictions for this analysis.}
\item{generate_model_performance}{A logical vector of length one; whether or not to generate measures of model performance for this analysis.}
\item{model_args}{A list; the arguments to be passed to the algorithm specified.}
\item{column_names}{A character vector; the column names.}
\item{categorical_variables}{A logical vector; the variables that are categorical.}
\item{X}{A data.frame; the full dataset to be used for modeling.}
\item{y}{A vector; the full response variable to be used for modeling.}
\item{coefficients}{A (n_variables, n_samples) matrix; the generated coefficients.}
\item{coefficients_processed}{A data.frame; the coefficients after being processed.}
\item{plot_coefficients_processed}{A ggplot object; the plot of the processed coefficients.}
\item{X_train}{A data.frame; the train dataset to be used for modeling.}
\item{X_test}{A data.frame; the test dataset to be used for modeling.}
\item{y_train}{A vector; the train response variable to be used for modeling.}
\item{y_test}{A vector; the test response variable to be used for modeling.}
\item{predictions_train}{A (nrow(X_train), n_samples) matrix; the train predictions.}
\item{predictions_test}{A (nrow(X_test), n_samples) matrix; the test predictions.}
\item{predictions_train_mean}{A vector; the mean train predictions.}
\item{predictions_test_mean}{A vector; the mean test predictions.}
\item{plot_predictions}{A function; the function for plotting predictions generated by the model.}
\item{plot_predictions_train_mean}{A ggplot object; the plot of the mean train predictions.}
\item{plot_predictions_test_mean}{A ggplot object; the plot of the mean test predictions.}
\item{model_performance_train}{A vector of length n_divisions; the measures of model performance on the train datasets.}
\item{model_performance_test}{A vector of length n_divisions; the measures of model performance on the test datasets.}
\item{plot_model_performance}{A function; the function for plotting the measures of model performance.}
\item{plot_model_performance_train}{A ggplot object; the plot of the measures of model performance on the train datasets.}
\item{plot_model_performance_test}{A ggplot object; the plot of the measures of model performance on the test datasets.}
}
}
\description{
This recipe is the workhorse behind all of the easy_* functions.
}
\seealso{
Other recipes: \code{\link{easy_avNNet}},
  \code{\link{easy_deep_neural_network}},
  \code{\link{easy_glinternet}}, \code{\link{easy_glmnet}},
  \code{\link{easy_neural_network}},
  \code{\link{easy_random_forest}},
  \code{\link{easy_support_vector_machine}}
}
