% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample_fold_train_test_split}
\alias{resample_fold_train_test_split}
\title{Sample with respect to an identification vector}
\usage{
resample_fold_train_test_split(X, y, train_size = 0.667, foldid = NULL,
  random_state = NULL)
}
\arguments{
\item{X}{A data.frame, the data to be resampled.}

\item{y}{A numeric vector with two classes, 0 and 1.}

\item{train_size}{A numeric vector of length one; specifies what proportion of the data should be used for the training data set. Defaults to 0.667.}

\item{foldid}{A vector with length equal to \code{length(y)} which identifies cases belonging to the same fold.}

\item{random_state}{An integer vector of length one; specifies the seed to be used for the analysis. Defaults to NULL.}
}
\value{
A boolean vector of length n_obs where TRUE represents that observation should be in the train set.
}
\description{
This will sample the training and test sets so that case identifiers (e.g. subject ID's) are not shared across training and test sets.
}
\seealso{
Other resample: \code{\link{resample_simple_train_test_split}},
  \code{\link{resample_stratified_class_train_test_split}},
  \code{\link{resample_stratified_simple_train_test_split}}
}
