% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindf-joinf.R
\name{match.factors}
\alias{match.factors}
\title{Match Factors.}
\usage{
match.factors(df1, df2, by = NA, sort.levels = TRUE)
}
\arguments{
\item{df1}{First data set.}

\item{df2}{Second data set.}

\item{by}{Columns to join on, comes from the function using match.factors (ljoinf, fjoinf, ijoinf).}

\item{sort.levels}{Sort the factor levels after combining them.}
}
\value{
List of the same data but with factors modified as applicable. All factors are checked if no 'by' argument is passed. Otherwise only the 'by' argument is checked.
}
\description{
Modifies two datasets so matching factor columns have the same levels. Typically this is used prior to joining or bind_rows in the easyr functions bindf, ijoinf, lfjoinf.
}
\examples{

df1 = data.frame(
  factor1 = c( 'a', 'b', 'c' ),
  factor2 = c( 'high', 'medium', 'low' ),
  factor.join = c( '0349038u093843', '304359867893753', '3409783509735' ),
  numeric = c( 1, 2, 3 ),
  logical = c( TRUE, TRUE, TRUE )
)

df2 = data.frame(
  factor1 = c( 'd', 'e', 'f' ),
  factor2 = c( 'low', 'medium', 'high' ),
  factor.join = c( '32532532536', '304359867893753', '32534745876' ),
  numeric = c( 4, 5, 6 ),
  logical = c( FALSE, FALSE, FALSE )
)

t = match.factors( df1, df2 )
levels( df1$factor1 )
levels( t[[1]]$factor1 )
levels( t[[2]]$factor1 )

}
