% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_datacubepaths.R
\name{ebv_datacubepaths}
\alias{ebv_datacubepaths}
\title{Get datacubepaths of EBV netCDF}
\usage{
ebv_datacubepaths(filepath, verbose = TRUE)
}
\arguments{
\item{filepath}{Character. Path to the netCDF file.}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Dataframe containing the paths to access the datacubes and
descriptions of scenario, metric and entity if existing.
}
\description{
Get the paths to the datacubes of the EBV netCDF to access the
data.
}
\examples{
#set path to EBV netCDF
file <- system.file(file.path("extdata","martins_comcom_subset.nc"), package="ebvcube")

#get all datacubepaths of EBV netCDF
datacubes <- ebv_datacubepaths(file)
}
