% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd_lazy.R
\name{lazy_load_ecd}
\alias{lazy_load_ecd}
\title{Reading Executive Communications Dataset lazily

This function imports data from the ECD lazily meaning the data is out loaded out of memory}
\usage{
lazy_load_ecd(
  country = NULL,
  language = NULL,
  full_ecd = FALSE,
  ecd_version = "1.0.0"
)
}
\arguments{
\item{country}{a character vector  with a country or countries in our dataset to download.}

\item{language}{a character vector with a lanaguage or languages in our dataset to download.}

\item{full_ecd}{to download the full Executive Communications Dataset set full_ecd to TRUE}

\item{ecd_version}{a character of ecd versions.}
}
\value{
A tibble with the specified country/countries or language/languages
}
\description{
Reading Executive Communications Dataset lazily

This function imports data from the ECD lazily meaning the data is out loaded out of memory
}
\examples{
\donttest{
library(ecdata)

## load one country 

load_ecd(country = 'United States of America')

## displays data from the USA


## load multiple countries 

load_ecd(country = c('Turkey', 'Republic of South Korea', 'India'))

## displays data from Turkey, South Korea, and India

# load full ecd 


load_ecd(full_ecd = TRUE)
}

}
