% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecr.ebars}
\alias{ecr.ebars}
\title{Error bars}
\usage{
ecr.ebars(wt, df = NULL, hwidth = 6, ...)
}
\arguments{
\item{wt}{A widget to add error bars to, see \link[htmlwidgets]{createWidget}}

\item{df}{NULL(default) or data.frame with four or more columns
ordered exactly x,y,low,high,(category),etc. When NULL, data is taken from
the wt dataset where order should be the same.}

\item{hwidth}{Half-width of error bar in pixels, default is 6.}

\item{...}{More parameters for \href{https://echarts.apache.org/en/option.html#series-custom.type}{custom serie}}
}
\value{
A widget with error bars added if successful, otherwise the input wt
}
\description{
Custom series to display error-bars for scatter,bar or line series
}
\details{
\emph{ecr.ebars} are custom series, so \emph{ec.init(load='custom')} is required. \cr
Command should be called after \emph{ec.init} where all other series are set.\cr
Have their own default tooltip format showing \emph{value & high/low}.\cr
Non-grouped series:\cr
\verb{     }Adding a name parameter will show error bars separate in the legend.\cr
\verb{     }Could be displayed with formatter \emph{riErrBarSimple} instead of \emph{ecr.ebars}. See example below.\cr
Grouped series are supported:\cr
\verb{     }param \emph{df} is required with group column included. \cr
\verb{     }chart's \emph{xAxis} needs to be type 'category'\cr
}
\examples{
library(dplyr)
df <- iris |> distinct(Sepal.Length, .keep_all= TRUE) |> 
  mutate(lo= Sepal.Width-Petal.Length/2, hi= Sepal.Width+Petal.Width) |>
  select(Sepal.Length, Sepal.Width, lo, hi, Species)
  
df |> ec.init(load='custom', legend=list(show=TRUE), xAxis=list(scale=TRUE)) |> 
  ecr.ebars(name= 'err')

# ----- grouped -------
dfg <- df |> group_by(Species)
dfg |> 
  ec.init(load= 'custom', legend= list(show=TRUE), xAxis= list(scale=TRUE)) |>
  ecr.ebars(dfg)
  
# ----- riErrBarSimple ------
df |> ec.init(load= 'custom',
              title= list(text= 'riErrBarSimple'),
              legend= list(show= TRUE),
              xAxis= list(scale= TRUE)
) |> ec.upd({
  series <- append(series, list(
    list(type= 'custom', name= 'error',
         itemStyle= list(color= 'brown'),
         data= ec.data(df |> select(Sepal.Length,lo,hi)),
         renderItem= htmlwidgets::JS('riErrBarSimple')) ))
})

}
