% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_trace_screen}
\alias{ec_trace_screen}
\title{Generate Screening probability traceplots}
\usage{
ec_trace_screen(draws, burnin = 100)
}
\arguments{
\item{draws}{A list, 'echoice2' draws object, from a model with attribute-based screening}

\item{burnin}{burn-in to remove}
}
\value{
A ggplot2 plot containing traceplots of draws
}
\description{
Generate Screening probability traceplots
}
\examples{
data(icecream)
#run MCMC sampler (use way more than 20 draws for actual use
icecream_scr_est <- icecream \%>\% dplyr::filter(id<20) \%>\% vd_est_vdm_screen(R=20)
ec_trace_screen(icecream_scr_est, burnin=1)


}
\seealso{
\code{\link[=ec_draws_MU]{ec_draws_MU()}} to obtain MU_theta draws,
\code{\link[=ec_boxplot_screen]{ec_boxplot_screen()}} to generate boxplot
}
