% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water.R
\name{echoGetEffluent}
\alias{echoGetEffluent}
\title{Downloads EPA ECHO DMR records of dischargers with NPDES permits}
\usage{
echoGetEffluent(p_id, verbose = FALSE, ...)
}
\arguments{
\item{p_id}{Character string specify the identifier for the service. Required.}

\item{verbose}{Logical, indicating whether to provide processing and retrieval messages. Defaults to FALSE}

\item{...}{Further arguments passed on as query parameters sent to EPA's ECHO API. For more options see: \url{https://echo.epa.gov/tools/web-services/effluent-charts#!/Effluent_Charts/get_eff_rest_services_get_effluent_chart}}
}
\value{
Returns a dataframe.
}
\description{
Downloads EPA ECHO DMR records of dischargers with NPDES permits
}
\examples{
\donttest{
## This example requires an internet connection to run

## Retrieve single DMR for flow

echoGetEffluent(p_id = 'tx0119407', parameter_code = '50050')
}
}
