% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{balanced_sampling2}
\alias{balanced_sampling2}
\title{Balanced sampling 2}
\usage{
balanced_sampling2(
  i,
  Y,
  mm,
  nn,
  YPU,
  H0Sim,
  HaSim,
  factEnv,
  resultsHa,
  transformation,
  method,
  model,
  nSect,
  sites,
  N
)
}
\arguments{
\item{i}{pointer to the index in the list of experimental designs to try.}

\item{Y}{index to the data.frame the function will work with.}

\item{mm}{number of site the function is working with in each iteration.}

\item{nn}{number of samples to consider in each iteration.}

\item{YPU}{label for the sites in each iteration, as used by
\code{\link[sampling:balancedtwostage]{sampling::balancedtwostage()}}}

\item{H0Sim}{simulated community from \code{SSP::simdata()} in which H0 is
true.}

\item{HaSim}{simulated community from \code{SSP::simdata()} in which H0 is
false.}

\item{resultsHa}{helper matrix that stores labels and later the results.}

\item{transformation}{Mathematical function to reduce the weight of very
dominant species.}

\item{method}{appropriate distance/dissimilarity metric (e.g. Gower,
Bray–Curtis, Jaccard, etc).}

\item{model}{which algorithm to use for the calculation? At the moment, the only
option is "nested.symmetric".}

\item{nSect}{Total number of sectors to be simulated in each data set.}

\item{sites}{Total number of sites to be simulated in each data set.}

\item{N}{Total number of samples to be simulated in each site.}
}
\value{
a data frame with values for observed F (for H0 and Ha), and the Ha mean
squares for residuals and variation among sites.
}
\description{
Develops the experimental design based on the provided conditions
}
\references{
Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.
}
\seealso{
\code{\link[sampling:balancedtwostage]{sampling::balancedtwostage()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
\keyword{internal}
