% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{write_tables}
\alias{write_tables}
\title{Write ecocomDP tables to file}
\usage{
write_tables(
  path,
  sep = ",",
  observation = NULL,
  location = NULL,
  taxon = NULL,
  dataset_summary = NULL,
  observation_ancillary = NULL,
  location_ancillary = NULL,
  taxon_ancillary = NULL,
  variable_mapping = NULL
)
}
\arguments{
\item{path}{(character) A path to the directory in which the files will be written.}

\item{sep}{(character) Field delimiter to use when writing files. Default is comma.}

\item{observation}{(tbl_df, tbl, data.frame) The observation table.}

\item{location}{(tbl_df, tbl, data.frame) The location table.}

\item{taxon}{(tbl_df, tbl, data.frame) The taxon table.}

\item{dataset_summary}{(tbl_df, tbl, data.frame) The dataset_summary table.}

\item{observation_ancillary}{(tbl_df, tbl, data.frame) The observation_ancillary table.}

\item{location_ancillary}{(tbl_df, tbl, data.frame) The location_ancillary table.}

\item{taxon_ancillary}{(tbl_df, tbl, data.frame) The taxon_ancillary table.}

\item{variable_mapping}{(tbl_df, tbl, data.frame) The variable_mapping table.}
}
\value{
ecocomDP tables as \code{sep} delimited files
}
\description{
Write ecocomDP tables to file
}
\examples{
# Create directory for the tables
mypath <- paste0(tempdir(), "/data")
dir.create(mypath)

# Create a couple inputs to write_tables()

flat <- ants_L0_flat

observation <- create_observation(
  L0_flat = flat, 
  observation_id = "observation_id", 
  event_id = "event_id", 
  package_id = "package_id",
  location_id = "location_id", 
  datetime = "datetime", 
  taxon_id = "taxon_id", 
  variable_name = "variable_name",
  value = "value",
  unit = "unit")

observation_ancillary <- create_observation_ancillary(
  L0_flat = flat,
  observation_id = "observation_id", 
  variable_name = c("trap.type", "trap.num", "moose.cage"))

# Write tables to file

write_tables(
  path = mypath, 
  observation = observation, 
  observation_ancillary = observation_ancillary)

dir(mypath)

# Clean up
unlink(mypath, recursive = TRUE)

}
