% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{bray_curtis}
\alias{bray_curtis}
\title{Bray-Curtis}
\usage{
bray_curtis(counts, weighted = TRUE, pairs = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{weighted}{If \code{TRUE}, the algorithm takes relative abundances into
account. If \code{FALSE}, only presence/absence is considered.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Bray-Curtis beta diversity metric.
}
\section{Calculation}{


In the formulas below, \code{x} and \code{y} are two columns (samples) from \code{counts}.
\code{n} is the number of rows (OTUs) in \code{counts}.

\deqn{D = \displaystyle \frac{\sum_{i = 1}^{n} |x_i - y_i|}{\sum_{i = 1}^{n} (x_i + y_i)}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(4, 0, 3, 2, 6)
  y <- c(0, 8, 0, 0, 5)
  sum(abs(x-y)) / sum(x+y)  
  #>  0.6428571
}\if{html}{\out{</div>}}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Bray-Curtis weighted distance matrix
    bray_curtis(ex_counts)
    
    # Bray-Curtis unweighted distance matrix
    bray_curtis(ex_counts, weighted = FALSE)
    
    # Only calculate distances for A vs all.
    bray_curtis(ex_counts, pairs = 1:3)
    
}
\references{
Sorenson T 1948.
A method of establishing groups of equal amplitude in plant sociology based on similarity of species content.
Kongelige Danske Videnskabernes Selskab, 5.

Bray JR and Curtis JT 1957.
An ordination of the upland forest communities of southern Wisconsin.
Ecological Monographs, 27(4).
\doi{10.2307/1942268}
}
\seealso{
Other beta_diversity: 
\code{\link{canberra}()},
\code{\link{euclidean}()},
\code{\link{generalized_unifrac}()},
\code{\link{gower}()},
\code{\link{jaccard}()},
\code{\link{kulczynski}()},
\code{\link{manhattan}()},
\code{\link{unweighted_unifrac}()},
\code{\link{variance_adjusted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
