% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecostatscale.R
\name{xt2fun}
\alias{xt2fun}
\title{Unbiased stability paramter estimation}
\usage{
xt2fun(x0, r, d, d_sd, dt, ndist)
}
\arguments{
\item{x0}{value of x^2 at time t (x(t) in Eq.5)}

\item{r}{per-capita growth rate (r in Eq.5)}

\item{d}{mean size of disturbance function (mu in Eq.5)}

\item{d_sd}{standard deviation of disturbance function (sigma in Eq.5)}

\item{dt}{time step (i.e. time between x0 and x1) - can be a vector of the same length as x0, or a number if all time steps are of equal length}

\item{ndist}{number of disturbances in each time step (equivalent to p(t+tau) in Eq.5) - must be same length as x0}
}
\value{
predicted value of x^2 at time t+dt
}
\description{
Function for solving for stability paramter values from observed time series.
Equivalent to Eq.5 in the main text.
}
\examples{
# simulate dynamics, with r=1, d=0, and d_sd=0.1
xtout<-symdyn(r=1, f=1, d=0, d_sd=0.1, sf=0.1, tmax=100)

# abundance in current time step
x0<-xtout$state[1:(nrow(xtout)-1)]
# abundance at t+1
x1<-xtout$state[2:nrow(xtout)]

dt<-diff(xtout$time)
ndist<-xtout$disturbed[-1]

# fit model - note square root transform of response variable,
# and log transform of parameter values

mod<-nls(sqrt(x1^2)~sqrt(xt2fun(x0, r=exp(lr), d=0, d_sd=exp(ld_sd), dt, ndist)),
         start=c(lr=log(1), ld_sd=log(0.1)))
exp(coef(mod)) # model estimates
}
