#' Lethal concentration data for seasonal exposure to TFM for larval sea lamprey
#'
#' This dataset contains 2011 seasonal larval sea lamprey exposed to the piscicide, 3-trifluoromethyl-4-nitrophenol (TFM) toxicity data.
#' @usage lamprey_tox
#' @format A tibble containing 64 rows and 7 columns.
#' \describe{
#'   \item{nominal.dose}{nominal TFM dose (mg/L)}
#'   \item{tank}{tank assignment}
#'   \item{month}{month in which toxicity test occurred}
#'   \item{dose}{averaged measured TFM dose (mg/L) over 12 h of exposure}
#'   \item{response}{number of lamprey that responded over 12 h exposure to TFM}
#'   \item{survive}{number of lamprey that survived over 12 h exposure to TFM}
#'   \item{total}{total number of lamprey that were exposed to TFM over 12 h}
#'   }
#' @details For each month, new lamprey were collected from the Deer Creek, MI, and were randomly assigned to a tank for exposure to varying doses of the piscicide, 3-trifluoromethyl-4-nitrophenol (TFM).
#' @source Hlina, B.L., Birceanu, O., Robinson, C.S., Thackeray, N., Tessier, L.R., Muhametsafina, A., Bragg, L.M., Servos, M.R., Wilkie, M.P. *In Preparation*. Changes in the sensitivity of piscicide in an invasive species. Environmental Science & Technology.


"lamprey_tox"
