% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupECRControl.R
\name{setupECRControl}
\alias{setupECRControl}
\title{Generates control object.}
\usage{
setupECRControl(n.population, n.offspring,
  n.mating.pool = floor(n.population/2), representation,
  survival.strategy = "plus", n.elite = 0L,
  monitor = setupConsoleMonitor(), stopping.conditions = list(),
  logger = NULL, custom.constants = list(), vectorized.evaluation = FALSE)
}
\arguments{
\item{n.population}{[\code{integer(1)}]\cr
Number of individuals in the population.}

\item{n.offspring}{[\code{integer(1)}]\cr
Number of individuals generated in each generation.}

\item{n.mating.pool}{[\code{integer(1)}]\cr
Number of individuals which can potentially participate in the
generation of offspring.
Default is half of the population size.}

\item{representation}{[\code{character(1)}]\cr
Genotype representation of the parameters. Available are \dQuote{binary},
\dQuote{float}, \dQuote{permutation} and \dQuote{custom}.}

\item{survival.strategy}{[\code{character(1)}]\cr
Determines the survival strategy used by the EA. Possible are \dQuote{plus} for
a classical (mu + lambda) strategy and \dQuote{comma} for (mu, lambda).
Default is \dQuote{plus}.}

\item{n.elite}{[\code{integer(1)}]\cr
Number of fittest individuals of the current generation that shall be copied to the
next generation without changing. Keep in mind, that the algorithm
does not care about this option if the \code{survival.strategy} is set to 'plus'.
Default is 0.}

\item{monitor}{[\code{function}]\cr
Monitoring function.
Default is \code{NULL}, i.e. no monitoring.}

\item{stopping.conditions}{[\code{list}]\cr
List of functions of type \code{ecr_terminator}. At least one stopping
condition needs to be passed.
Default is the empty list.}

\item{logger}{[\code{function}]\cr
Monitoring object used to log stuff.
Default is \code{NULL} which means no logging at all.
See \code{\link{setupOptPathLoggingMonitor}} for ecr's build-in logger.}

\item{custom.constants}{[\code{list}]\cr
Additional constants which should be available to all generators and operators.
Defaults to empty list.}

\item{vectorized.evaluation}{[\code{logical(1L)}]\cr
Is the fitness/objective function vectorized? I.e., does the fitness function accept
a list? This allows for faster execution or parallelization by hand.
If \code{TRUE} the following destinction on the type of the objective function is made:
\describe{
  \item{Is \code{smoof_function}}{If the objective function is of type \code{smoof_function} from package \pkg{smoof}
  and the smoof function is vectorized, the population - which is a list internally -
  is reduced to a matrix and passed to the smoof function (vectorization in smoof
  is allowed for continuous functions only).}
  \item{Is not a \code{smoof_function}}{In this case the individuals of
  the population are passed entirely as a list to the objective function.}
}
Default is \code{FALSE}.}
}
\value{
S3 object of type \code{ecr_control}.
}
\description{
The ecr package offers a framework for evolutionary computing and therefore offers
a lot of customization options. The control object is a simple
wrapper for all these options and sets convenient defaults.
}

