% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_map.R
\name{sd_map}
\alias{sd_map}
\title{A function to create a map of all school districts in a state}
\usage{
sd_map(state="New Jersey", county = NULL, map_var = "Student Poverty",
  level = "elem", legend= TRUE)
}
\arguments{
\item{state}{The state for which you want to map school districts.  Defaults
to New Jersey.}

\item{county}{The county for which you want to map school districts.
Defaults to NULL. To view a full list of counties use
\code{sd_shapepull(year = "2018", with_data = TRUE)}}

\item{map_var}{Variable by which to symbolize the map. \itemize{
\item{\code{Student Poverty} colors by student poverty rate}
\item{\code{Total Revenue} colors by state and local revenue per pupil}
\item{\code{Local Revenue} colors by local revenue per pupil} \item
{\code{State Revenue} colors by state revenue per pupil} \item
{\code{Percent Nonwhite} colors by percent nonwhite enrollment} \item
{\code{Median Household Income} colors by median household income } \item{
\code{Median Property Value} colors by owner-occupied median property value
} \item {\code{FRL} colors by free and reduced price lunch rate} } Defaults
to \code{Student Poverty}}

\item{level}{Selects which level of school districts you want displayed in
the map. \itemize{ \item{\code{elem} {displays elementary and unified
districts}} \item{\code{secon} {displays secondary and unified districts}}}
Defaults to \code{elem}.}

\item{legend}{If TRUE, legend is visible. Defaults to TRUE.}
}
\value{
An image of the map which can be written out with
  \code{tmap::tmap_save(map, '~/Documents/map.png')}
}
\description{
This function allows you to create a map of all school
  districts, in each state in the United States, symbolized by selected
  variables from the EdBuild master dataset.
}
\examples{
\donttest{map <- sd_map(state="Georgia", map_var = "Percent Nonwhite",
 level = "elem", legend= TRUE)}
}
\seealso{
\code{\link{sd_neighbor_map}}
}
\keyword{EdBuild}
\keyword{districts}
\keyword{map}
\keyword{school}
