% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_precedence_resource.R
\name{filter_precedence_resource}
\alias{filter_precedence_resource}
\alias{filter_precedence_resource.eventlog}
\alias{filter_precedence_resource.activitylog}
\alias{filter_precedence_resource.grouped_log}
\title{Filter Precedence Relations with Identical Resources}
\usage{
filter_precedence_resource(
  log,
  antecedents,
  consequents,
  precedence_type = c("directly_follows", "eventually_follows"),
  filter_method = c("all", "one_of", "none"),
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_precedence_resource}{eventlog}(
  log,
  antecedents,
  consequents,
  precedence_type = c("directly_follows", "eventually_follows"),
  filter_method = c("all", "one_of", "none"),
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_precedence_resource}{activitylog}(
  log,
  antecedents,
  consequents,
  precedence_type = c("directly_follows", "eventually_follows"),
  filter_method = c("all", "one_of", "none"),
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_precedence_resource}{grouped_log}(
  log,
  antecedents,
  consequents,
  precedence_type = c("directly_follows", "eventually_follows"),
  filter_method = c("all", "one_of", "none"),
  reverse = FALSE,
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{antecedents, consequents}{\code{\link{character}} vector: The set of antecendent and consequent activities.
Both are \code{\link{character}} vectors containing at least one activity identifier. All pairs of antecedents and consequents are turned into seperate precedence rules.}

\item{precedence_type}{\code{\link{character}} (default \code{"directly_follows"}): When \code{"directly_follows"},
the consequent activity should happen immediately after the antecedent activities.\cr
When \code{"eventually_follows"}, other events are allowed to happen in between.}

\item{filter_method}{\code{\link{character}} (default \code{"all"}): When \code{"all"}, only cases where all the relations are valid are preserved.\cr
When \code{"one_of"}, all the cases where at least one of the conditions hold, are preserved.\cr
When \code{"none"}, none of the relations are allowed.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Filters cases based on the precedence relations between two sets of activities, where both antecendent
and consequent have to be executed by the same resource.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_precedence_resource(eventlog)}: Filters cases for an \code{\link[bupaR:eventlog]{eventlog}}.

\item \code{filter_precedence_resource(activitylog)}: Filters cases for an \code{\link[bupaR:activitylog]{activitylog}}.

\item \code{filter_precedence_resource(grouped_log)}: Filters cases for a \code{\link[bupaR:grouped_log]{grouped_log}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link[=filter_precedence]{filter_precedence()}}

Other filters: 
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_instance}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_activity}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_case}()},
\code{\link{filter_endpoints_condition}()},
\code{\link{filter_endpoints}()},
\code{\link{filter_flow_time}()},
\code{\link{filter_idle_time}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence}()},
\code{\link{filter_processing_time}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_resource}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trace}()},
\code{\link{filter_trim_lifecycle}()},
\code{\link{filter_trim}()}
}
\concept{filters}
\concept{filters_case}
