% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eefAnalytics_03_2017.r
\name{srtFREQ}
\alias{srtFREQ}
\title{Analysis of Simple Randomised Education Trial using Linear Regression Model.}
\usage{
srtFREQ(formula, intervention, nBoot = NULL, nPerm = NULL, data)
}
\arguments{
\item{formula}{the model to be analysed. It is of the form y~x1+x2+.... Where y is the outcome variable and Xs are the predictors.}

\item{intervention}{a string variable specifying the "intervention variable" as appeared in the formula. See example below}

\item{nBoot}{number of bootstraps required to generate bootstrap confidence interval. Default is NULL.}

\item{nPerm}{number of permutations required to generate permutated p-value.  Default is NULL.}

\item{data}{data frame containing the data to be analysed.}
}
\value{
S3 object; a list consisting of
\itemize{
\item \code{Beta}. Estimates and confidence intervals for the predictors specified in the model.
\item \code{ES}. Hedges' g effect size for the intervention(s). If nBoot is not specified, the confidence intervals are 95% CIs based on standard errors. If nBoot is specified, they are non-parametric bootstrapped confidence intervals.
\item \code{sigma2}. Residual variance.
\item \code{Perm}. A vector containing permutated effect sizes under null hypothesis. It is produced only if \code{nPerm} is specified.
\item \code{Bootstrap}. A vector containing bootstrapped effect sizes. It is prduced only if \code{nBoot} is specified.
}
}
\description{
\code{srtFREQ} perfoms analysis of educational trials under the assumption of independent errors among pupils. 
This can also be used with schools as fixed effects.
}
\examples{
if(interactive()){

data(mstData)

###################################################################
## Analysis of simple randomised trials using Hedges Effect Size ##
###################################################################

output1 <- srtFREQ(Posttest~ Intervention+Prettest,
		intervention="Intervention",data=mstData )
ES1 <- output1$ES
ES1

###################################################################
## Analysis of simple randomised trials using Hedges Effect Size ## 
## with Permutation p-value                                      ##
###################################################################

output2 <- srtFREQ(Posttest~ Intervention+Prettest,
		intervention="Intervention",nPerm=1000,data=mstData )

ES2 <- output2$ES
ES2


#### plot permutated values

plot(output2, group=1)



###################################################################
## Analysis of simple randomised trials using Hedges Effect Size ##
## with non-parametric bootstrap confidence intervals            ##
###################################################################

output3 <- srtFREQ(Posttest~ Intervention+Prettest,
		intervention="Intervention",nBoot=1000,data=mstData)

ES3 <- output3$ES
ES3

### plot bootstrapped values

plot(output3, group=1)

####################################################################
## Analysis of simple randomised trials using Hedges' effect size  ##
##  with schools as fixed effects                                  ##
####################################################################

output4 <- srtFREQ(Posttest~ Intervention+Prettest+as.factor(School),
		intervention="Intervention",data=mstData )

ES4 <- output4$ES
ES4

####################################################################
## Analysis of simple randomised trials using Hedges' effect size ##
## with schools as fixed effects and with permutation p-value     ##
####################################################################

output5 <- srtFREQ(Posttest~ Intervention+Prettest+as.factor(School),
		intervention="Intervention",nPerm=1000,data=mstData )

ES5 <- output5$ES
ES5

#### plot permutated values

plot(output5, group=1)

####################################################################
## Analysis of simple randomised trials using Hedges' effect size ##
## with schools as fixed effects and with permutation p-value      ##
####################################################################

output6 <- srtFREQ(Posttest~ Intervention+Prettest+as.factor(School),
		intervention="Intervention",nBoot=1000,data=mstData)

ES6 <- output6$ES
ES6 

### plot bootstrapped values

plot(output6, group=1)
}
}

