% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_icc.R
\name{interpret_icc}
\alias{interpret_icc}
\title{Interpret Intraclass Correlation Coefficient (ICC)}
\usage{
interpret_icc(icc, rules = "koo2016", ...)
}
\arguments{
\item{icc}{Value or vector of Intraclass Correlation Coefficient (ICC) values.}

\item{rules}{Can be \code{"koo2016"} (default) or custom set of \code{\link[=rules]{rules()}}.}

\item{...}{Not used for now.}
}
\description{
The value of an ICC lies between 0 to 1, with 0 indicating no reliability among raters and 1 indicating perfect reliability.
}
\section{Rules}{

\itemize{
\item Koo (2016) (\code{"koo2016"}; default)
\itemize{
\item \strong{ICC < 0.50} - Poor reliability
\item \strong{0.5 <= ICC < 0.75} - Moderate reliability
\item \strong{0.75 <= ICC < 0.9} - Good reliability
\item **ICC >= 0.9 ** - Excellent reliability
}
}
}

\examples{
interpret_icc(0.6)
interpret_icc(c(0.4, 0.8))
}
\references{
\itemize{
\item Koo, T. K., and Li, M. Y. (2016). A guideline of selecting and reporting intraclass correlation coefficients for reliability research. Journal of chiropractic medicine, 15(2), 155-163.
}
}
