% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-eglm.R
\name{predict.eglm}
\alias{predict.eglm}
\title{Predict Method for eglm Fits}
\usage{
\method{predict}{eglm}(
  object,
  newdata,
  se.fit = FALSE,
  scale = NULL,
  df = Inf,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  type = c("link", "response", "terms"),
  terms = NULL,
  na.action = na.pass,
  weights = NULL,
  ...
)
}
\arguments{
\item{object}{a fitted object of class inheriting from "eglm"}

\item{newdata}{optionally, a data frame in which to look for variables with
which to predict. If omitted, the fitted linear predictors are used}

\item{se.fit}{A switch indicating if standard errors are required.}

\item{type}{the type of prediction required. The default is on the scale of
the linear predictors; the alternative "response" is on the scale of the
response variable. Thus for a default binomial model the default predictions
are of log-odds (probabilities on logit scale) and type = "response" gives
the predicted probabilities. The "terms" option returns a matrix giving the
fitted values of each term in the model formula on the linear predictor
scale}

\item{na.action}{function determining what should be done with missing values
in newdata. The default is to predict NA}

\item{...}{further arguments passed to or from other methods}
}
\value{
An object of class "numeric" or "matrix", see the function \link{predict.glm}.
}
\description{
Obtains predictions and optionally estimates standard errors of
those predictions from a fitted generalized linear model object (see the
function \link{predict.glm}).
}
\keyword{internal}
