% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ego.design.R
\docType{methods}
\name{ego_design}
\alias{ego_design}
\alias{ego_design.egor}
\alias{ego_design.nested_egor}
\alias{ego_design<-}
\alias{ego_design<-.egor}
\alias{ego_design<-.nested_egor}
\alias{has_ego_design}
\alias{has_ego_design.egor}
\alias{has_ego_design.nested_egor}
\alias{strip_ego_design}
\title{Set and query the ego sampling design}
\usage{
ego_design(x, ...)

\method{ego_design}{egor}(x, ...)

\method{ego_design}{nested_egor}(x, ...)

ego_design(x, ...) <- value

\method{ego_design}{egor}(x, ...) <- value

\method{ego_design}{nested_egor}(x, ...) <- value

has_ego_design(x)

\method{has_ego_design}{egor}(x)

\method{has_ego_design}{nested_egor}(x)

strip_ego_design(x)
}
\arguments{
\item{x}{an \code{\link{egor}} object.}

\item{...}{arguments to be passed to methods}

\item{value}{a \code{\link{list}} of arguments to \code{\link[srvyr:as_survey_design]{srvyr::as_survey_design()}}
specifying the sampling design for the egos. If the arguments are
formulas, they can refer to columns (ego attributes) of
\code{x}. \code{NULL} clears design information.}
}
\description{
Extract, set, remove, or update the survey design associated with
an ego-centered dataset.
}
\note{
This can be useful for adjusting or reinitializing the ego
design information after the underlying ego attributes had been
modified.
}
