% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eicm-options.r
\name{eicm.matrix}
\alias{eicm.matrix}
\title{Define a model object for a EICM model}
\usage{
eicm.matrix(env.coefs, sp.coefs = NULL, latent = NULL,
  options = NULL)
}
\arguments{
\item{env.coefs}{the environmental coefficient matrix: a species x variable matrix (including intercept).}

\item{sp.coefs}{the species interaction coefficient matrix: a species x species matrix, with zero diagonal.}

\item{latent}{the values for the latent variables in each sample: a sample x latent variable matrix.}

\item{options}{options for the model fitting.}
}
\value{
A \code{eicm.matrix} object that can be used for defining a model.
}
\description{
Constructs a EICM model object for prediction. The model object contains all coefficient matrices that may be needed for prediction.
Usually, you don't need to invoke this function directly, use \code{\link{as.eicm}} instead.
}
\details{
The EICM model is a list composed of three matrices plus the fitting options:
\enumerate{
  \item env
  \item sp
  \item samples
}
}
