% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_create.R
\name{wrf_create}
\alias{wrf_create}
\title{Create emission files to the WRF-Chem}
\usage{
wrf_create(wrfinput_dir = "", wrfchemi_dir = "", domains = 1,
  frames_per_auxinput5 = 1, auxinput5_interval_m = 60, day_offset = 0,
  io_style_emissions = 2, kemit = 1, variaveis = c("E_NO2", "E_NO",
  "E_TOL", "E_XYL", "E_ALD", "E_ALDX", "E_SO2", "E_CO", "E_OLT", "E_OLI",
  "E_OL2", "E_NH3", "E_ISO", "E_HCL", "E_HCHO", "E_ETH", "E_CH3OH", "E_C2H5OH",
  "E_HC3", "E_HC5", "E_HC8", "E_KET", "E_ORA2", "E_CSL", "E_TERP", "E_PM25I",
  "E_PM25J", "E_ECI", "E_ECJ", "E_ORGI", "E_ORGJ", "E_SO4I", "E_SO4J", "E_NO3J",
  "E_NO3I", "E_SO4C", "E_NO3C", "E_ORGC", "E_ECC", "E_PM10"), n_aero = 15,
  COMPRESS = NA, force_ncdf4 = FALSE, verbose = FALSE)
}
\arguments{
\item{wrfinput_dir}{folder with the wrfinput file(s)}

\item{wrfchemi_dir}{output folder}

\item{domains}{domain or domains to process}

\item{frames_per_auxinput5}{value from wrf &time_control namelist.input,
number of times in a single emission file}

\item{auxinput5_interval_m}{value from wrf &time_control namelist.input,
interval in minutes between different times}

\item{day_offset}{number of days (can be a fracion) to create multiple files}

\item{io_style_emissions}{from wrf &chem namelist.input}

\item{kemit}{from wrf &chem namelist.input, number of levels of the emission file}

\item{variaveis}{emission species, can be used data(emis_opt)}

\item{n_aero}{number of aerosol species}

\item{COMPRESS}{integer between 1 (least compr) and 9 (most compr) or NA for
no compression}

\item{force_ncdf4}{force NetCDF4 format}

\item{verbose}{print file info}
}
\description{
Create an emission file from wrfinput
}
\note{
to use io_style_emissions = 1, use day_offset increased by 0.5
(to increase 12h)

Windowns users need to rename the emission files
from 'wrfchemi_d01_2011-08-01_00_00_00' to 'wrfchemi_d01_2011-08-01_00:00:00'
before run wrf.exe with these files
}
\examples{
\dontrun{
# Do not run

# emissions for a 1 day forecast for domains 1 and 2

dir.create(file.path(tempdir(), "EMISS"))

wrf_create(wrfinput_dir         = system.file("extdata", package = "eixport"),
           wrfchemi_dir         = file.path(tempdir(), "EMISS"),
           domains              = 1:2,
           frames_per_auxinput5 = 24,
           auxinput5_interval_m = 60,
           day_offset           = 0,
           verbose              = TRUE)

# emission for the last timestep

wrf_create(wrfinput_dir         = system.file("extdata", package = "eixport"),
           wrfchemi_dir         = file.path(tempdir(), "EMISS"),
           domains              = 1:2,
           frames_per_auxinput5 = 1,
           auxinput5_interval_m = 60,
           day_offset           = 1,
           verbose              = TRUE)
}
}
\seealso{
\code{\link{to_wrf}} and \code{\link{emis_opt}}
}
\author{
Daniel Schuch
}
