% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\alias{cluster_health}
\alias{cluster_pending_tasks}
\alias{cluster_reroute}
\alias{cluster_settings}
\alias{cluster_state}
\alias{cluster_stats}
\title{Elasticsearch cluster endpoints}
\usage{
cluster_settings(index = NULL, raw = FALSE, callopts = list(),
  verbose = TRUE, ...)

cluster_health(index = NULL, raw = FALSE, callopts = list(),
  verbose = TRUE, ...)

cluster_state(index = NULL, raw = FALSE, callopts = list(),
  verbose = TRUE, ...)

cluster_stats(index = NULL, raw = FALSE, callopts = list(),
  verbose = TRUE, ...)

cluster_reroute(index = NULL, raw = FALSE, callopts = list(),
  verbose = TRUE, ...)

cluster_pending_tasks(index = NULL, raw = FALSE, callopts = list(),
  verbose = TRUE, ...)
}
\arguments{
\item{index}{Index}

\item{raw}{If TRUE (default), data is parsed to list. If FALSE, then raw JSON.}

\item{callopts}{Curl args passed on to httr::POST.}

\item{verbose}{If TRUE (default) the url call used printed to console.}

\item{...}{Further args passed on to elastic search HTTP API as parameters.}
}
\description{
Elasticsearch cluster endpoints
}
\details{
Additional parameters that can be passed in:
\itemize{
  \item metric A comma-separated list of metrics to display. Possible values: '_all',
'completion', 'docs', 'fielddata', 'filter_cache', 'flush', 'get', 'id_cache', 'indexing',
'merge', 'percolate', 'refresh', 'search', 'segments', 'store', 'warmer'
  \item completion_fields A comma-separated list of fields for completion metric (supports
wildcards)
  \item fielddata_fields A comma-separated list of fields for fielddata metric (supports
wildcards)
  \item fields A comma-separated list of fields for fielddata and completion metric (supports
wildcards)
  \item groups A comma-separated list of search groups for search statistics
  \item allow_no_indices Whether to ignore if a wildcard indices expression resolves into no
concrete indices. (This includes _all string or when no indices have been specified)
  \item expand_wildcards Whether to expand wildcard expression to concrete indices that are
open, closed or both.
  \item ignore_indices When performed on multiple indices, allows to ignore missing ones
(default: none)
  \item ignore_unavailable Whether specified concrete indices should be ignored when unavailable
(missing or closed)
  \item human Whether to return time and byte values in human-readable format.
  \item level Return stats aggregated at cluster, index or shard level. ('cluster', 'indices'
or 'shards', default: 'indices')
  \item types A comma-separated list of document types for the indexing index metric
}
}
\examples{
\dontrun{
cluster_settings()
cluster_health()
cluster_state()
cluster_stats()
cluster_pending_tasks()

# raw json data
cluster_health(raw = TRUE)
}
}

