% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.r
\name{count}
\alias{count}
\title{Get counts of the number of records per index.}
\usage{
count(index = NULL, type = NULL, callopts = list(), verbose = TRUE, ...)
}
\arguments{
\item{index}{Index, defaults to all indices}

\item{type}{Document type}

\item{callopts}{Curl args passed on to httr::GET.}

\item{verbose}{If TRUE (default) the url call used printed to console.}

\item{...}{Further args passed on to elastic search HTTP API as parameters.}
}
\description{
Get counts of the number of records per index.
}
\details{
See docs for the count API here
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/search-count.html}

You can also get a count of documents using \code{\link{Search}} or 
\code{\link{Search_uri}} and setting \code{size = 0}
}
\examples{
\dontrun{
count()
count(index='plos')
count(index='plos', type='article')
count(index='shakespeare')
count(index=c('plos','shakespeare'), q="a*")
count(index=c('plos','shakespeare'), q="z*")

# Curl options
library("httr")
count(callopts=verbose())
}
}
