% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/party_mun_zone.R
\name{party_mun_zone}
\alias{party_mun_zone}
\title{Download data on the polls by parties from federal elections in Brazil}
\usage{
party_mun_zone(
  year,
  uf = "all",
  br_archive = FALSE,
  encoding = "latin1",
  temp = TRUE,
  readme_pdf = FALSE
)
}
\arguments{
\item{year}{Election year. For this function, only the years 1994, 1998, 2002, 2006, 2010, 2014 and 2018
are available.}

\item{uf}{Filter results by Federation Unit acronym (\code{character vector}).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recoverns only electoral data for presidential elections, absent in other files).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE}, keep the temporary compressed file for future use (recommended)}

\item{readme_pdf}{original readme}
}
\value{
\code{party_mun_zone()} returns a \code{data.frame}.
}
\description{
\code{party_mun_zone()} downloads and aggregates the data on the polls by parties from the federal elections in Brazil,
disaggregated by cities and electoral zones. The function returns a \code{data.frame} where each observation
corresponds to a city/zone.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2002, some information can be incomplete. For the 2014 and 2018 elections, more variable are available.
}
\examples{
\dontrun{
df <- party_mun_zone(2002)
}
}
