% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.em.glm}
\alias{residuals.em.glm}
\title{Deviance residuals for an 'em.glm' object.}
\usage{
\method{residuals}{em.glm}(object, x, y, weight = c(1),
  type = "deviance", ...)
}
\arguments{
\item{object}{An 'em.glm' object.}

\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{type}{Residual type - either deviance or Pearson's residuals.}

\item{...}{other arguments.}
}
\value{
An n length vector of residuals.
}
\description{
Deviance residuals for an 'em.glm' object.
}
\examples{
x <- model.matrix(~ factor(wool) + factor(tension), warpbreaks)
y <- warpbreaks$breaks

m <- em.glm(x = x, y = y, K = 2, b.init = "random")

residuals(m, x = x, y = y)

}
